/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * blancoCodeGenerator̎R[h\郉bp[NXB
 * 
 * @deprecated ̃NX̗p͐܂B݊̂߂ɎcĂ邾łB
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class Cast extends Statement {
    private Type _type = null;

    private Statement _statement = null;

    public Cast(Type castType) {
        _type = castType;
    }

    public Cast(Class type) {
        this(new Type(type));
    }

    public Call call(String methodName) {
        Call result = new Call(methodName);
        _statement = result;
        return result;
    }

    public Receiver value(Value value) {
        Receiver result = new Receiver(value);
        _statement = result;
        return result;
    }

    public void setStatement(Statement statement) {
        _statement = statement;
        addSubStatement(statement);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(_type.getName());
        sb.append(") ");
        sb.append(_statement.toString());
        return sb.toString();
    }

}
