/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.service;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.service.resourcebundle.BlancoServiceResourceBundle;
import blanco.service.valueobject.BlancoServiceStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uT[rX`vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoServiceXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoServiceResourceBundle fBundle = new BlancoServiceResourceBundle();

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // V[gڍׂȏ擾܂B
            final BlancoServiceStructure processStructure = parseSheet(
                    elementCommon, argDirectoryTarget);

            if (processStructure != null) {
                // ^̉͌ʂƂɃ\[XR[hs܂B
                new BlancoServiceXml2SourceFileAbstractProcess().process(
                        processStructure, argDirectoryTarget);
                new BlancoServiceXml2SourceFileServlet().process(
                        processStructure, argDirectoryTarget);
            }
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoServiceStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final File argDirectoryTarget) {

        final BlancoServiceStructure processStructure = new BlancoServiceStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        return processStructure;
    }
}
