/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.expand;

import java.io.File;
import java.math.BigDecimal;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthDotNetResourceBundle;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthReaderDotNetResourceBundle;
import blanco.fixedlength.valueobject.BlancoFixedLengthFieldStructureDotNet;
import blanco.fixedlength.valueobject.BlancoFixedLengthStructureDotNet;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoFixedLengthExpandReaderDotNet {
    final BlancoFixedLengthDotNetResourceBundle bundle = new BlancoFixedLengthDotNetResourceBundle();

    final BlancoFixedLengthReaderDotNetResourceBundle readerBundle = new BlancoFixedLengthReaderDotNetResourceBundle();

    public void expand(final BlancoFixedLengthStructureDotNet processStructure,
            final File directoryTarget) {

        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + readerBundle.getClassNameSuffix();
        final Type typeIOException = new Type(processStructure
                .getRuntimePackage()
                + readerBundle.getAddusingtype01Suffix());
        final ClassExpander classExpander = new ClassExpander(new Type(
                processStructure.getPackageName()
                        + readerBundle.getPackagePrefix(), className)) {
            protected void expandClassStruct() {
                addImport(typeIOException);
                addImport(new IgType("System.FormatException"));

                addFileComment(readerBundle.getFilecomment());

                getJavaDoc()
                        .addLine(
                                readerBundle
                                        .getClasscomment01(processStructure
                                                .getFileDefinitionId()
                                                + (processStructure
                                                        .getFileDescription() == null ? ""
                                                        : "/"
                                                                + processStructure
                                                                        .getFileDescription())));
                getJavaDoc().addLine(readerBundle.getClasscomment02());
                getJavaDoc().addLine(readerBundle.getClasscomment03Case01());
                getJavaDoc().addLine(readerBundle.getClasscomment04());

                final FieldExpander field1 = new FieldExpander(new Type(
                        readerBundle.getFieldReaderType()), readerBundle
                        .getFieldReaderName());
                field1.getJavaDoc().addLine(
                        readerBundle.getFieldReaderJavadoc01());
                field1.getJavaDoc().addLine(
                        readerBundle.getFieldReaderJavadoc02());
                addField(field1);

                final FieldExpander field2 = new FieldExpander(new Type(
                        readerBundle.getFieldLineCounterType()), readerBundle
                        .getFieldLineCounterName());
                field2.getJavaDoc().addLine(
                        readerBundle.getFieldLineCounterJavadoc01());
                field2.getJavaDoc().addLine(
                        readerBundle.getFieldLineCounterJavadoc02());
                field2.setDefaultStatement(new Statement(readerBundle
                        .getFieldLineCounterDefault()));
                addField(field2);

                // uvΉ
                for (int indexField = 0; indexField < processStructure
                        .getListField().size(); indexField++) {
                    final BlancoFixedLengthFieldStructureDotNet field = (BlancoFixedLengthFieldStructureDotNet) processStructure
                            .getListField().get(indexField);

                    if (field.getType().equals("System.DateTime")) {
                        final FieldExpander field3 = new FieldExpander(
                                new Type(readerBundle
                                        .getFieldSimpleDateFormatType()),
                                readerBundle
                                        .getFieldSimpleDateFormatNamePrefix()
                                        + BlancoNameAdjuster.toClassName(field
                                                .getName()));
                        field3
                                .getJavaDoc()
                                .addLine(
                                        readerBundle
                                                .getFieldSimpleDateFormatJavadoc01(field
                                                        .getName()));
                        field3.getJavaDoc().addLine(
                                readerBundle
                                        .getFieldSimpleDateFormatJavadoc02());
                        addField(field3);
                    }
                }

                addMethod(new Constructor(className) {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                readerBundle.getConstructor01Javadoc01());
                        getJavaDoc().addLine(
                                readerBundle.getConstructor01Javadoc02());
                        getJavaDoc().addParameter("arg",
                                readerBundle.getConstructor01Arg01Javadoc01());
                        addArgument(new Value(new Type(readerBundle
                                .getConstructor01Arg01Type()), "arg"));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("fReader = arg;");

                        // uvΉ
                        for (int indexField = 0; indexField < processStructure
                                .getListField().size(); indexField++) {
                            final BlancoFixedLengthFieldStructureDotNet field = (BlancoFixedLengthFieldStructureDotNet) processStructure
                                    .getListField().get(indexField);

                            if (field.getType().equals("System.DateTime")) {
                                getData()
                                        .addLine(
                                                readerBundle
                                                        .getFieldSimpleDateFormatNamePrefix()
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + " = "
                                                        + (field.getFormat() == null ? "\"yyyy/MM/dd\""
                                                                : "\""
                                                                        + field
                                                                                .getFormat()
                                                                        + "\"")
                                                        + ";");
                            }
                        }

                    }
                });

                final String recordClassName = processStructure
                        .getPackageName()
                        + ".record."
                        + BlancoNameAdjuster.toClassName(processStructure
                                .getFileDefinitionId()) + "FixedLengthRecord";

                addMethod(new MethodExpander("ReadRecord") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(
                                readerBundle.getReadrecordJavadoc());
                        getJavaDoc().addReturn(
                                readerBundle.getReadrecordReturnJavadoc());
                        getJavaDoc().addException(typeIOException,
                                readerBundle.getReadrecordThrows01Javadoc());
                        getJavaDoc().addException(
                                new Type(readerBundle
                                        .getReadrecordThrows02Type()),
                                readerBundle.getReadrecordThrows02Javadoc());
                        addException(typeIOException);
                        addException(new Type(readerBundle
                                .getReadrecordThrows02Type()));
                        setReturnType(new Type(recordClassName));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("string line = fReader.ReadLine();");
                        getData().addLine("if (line == null) {");
                        getData().addLine(readerBundle.getReadrecordLine03());
                        getData().addLine("return null;");
                        getData().addLine("}");
                        getData().addLine("fLineCounter++;");
                        getData()
                                .addLine(
                                        readerBundle
                                                .getReadrecordLine07(BlancoNameAdjuster
                                                        .toClassName(processStructure
                                                                .getFileDefinitionId())));
                        addUsingType(new Type("System.IO.StringReader"));
                        getData()
                                .addLine(
                                        "StringReader reader = new StringReader(line);");
                        getData().addLine("string tokenString = null;");

                        for (int indexField = 0; indexField < processStructure
                                .getListField().size(); indexField++) {
                            final BlancoFixedLengthFieldStructureDotNet field = (BlancoFixedLengthFieldStructureDotNet) processStructure
                                    .getListField().get(indexField);

                            getData().addLine("");
                            getData()
                                    .addLine(
                                            (readerBundle
                                                    .getReadrecordLine12(
                                                            (field.getNo() == null ? ""
                                                                    : bundle
                                                                            .getFieldNo(field
                                                                                    .getNo())),
                                                            field.getName()
                                                                    + (field
                                                                            .getDescription() == null ? ""
                                                                            : "/"
                                                                                    + field
                                                                                            .getDescription()))));

                            addUsingType(new Type(processStructure
                                    .getRuntimePackage()
                                    + ".util.BlancoFixedLengthRuntimeUtil"));
                            getData()
                                    .addLine(
                                            readerBundle
                                                    .getReadrecordLine22(new BigDecimal(
                                                            String
                                                                    .valueOf(field
                                                                            .getLength()))));

                            getData().addLine(
                                    "if (BlancoFixedLengthRuntimeUtil.GetBytes(tokenString).Length < "
                                            + field.getLength() + ") {");
                            getData()
                                    .addLine(
                                            "throw new BlancoFixedLengthIOException(\""
                                                    + bundle
                                                            .getCsvReaderErr002(
                                                                    getLocationString(
                                                                            indexField,
                                                                            field
                                                                                    .getNo(),
                                                                            field
                                                                                    .getName(),
                                                                            field
                                                                                    .getDescription()),
                                                                    field
                                                                            .getLength())
                                                    + "\");");
                            getData().addLine("}");

                            getData().addLine(
                                    "if (BlancoFixedLengthRuntimeUtil.GetBytes(tokenString).Length > "
                                            + field.getLength() + ") {");
                            getData()
                                    .addLine(
                                            "throw new BlancoFixedLengthIOException(\""
                                                    + bundle
                                                            .getCsvReaderErr003(
                                                                    getLocationString(
                                                                            indexField,
                                                                            field
                                                                                    .getNo(),
                                                                            field
                                                                                    .getName(),
                                                                            field
                                                                                    .getDescription()),
                                                                    field
                                                                            .getLength())
                                                    + "\");");
                            getData().addLine("}");

                            if (field.getType().equals("string")) {
                                getData().addLine(
                                        "record.Set"
                                                + BlancoNameAdjuster
                                                        .toClassName(field
                                                                .getName())
                                                + "(tokenString);");
                            } else if (field.getType().equals("int")) {
                                getData().addLine("try {");
                                getData()
                                        .addLine(
                                                "record.Set"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "(Int32.Parse(tokenString.Trim()));");
                                getData().addLine(
                                        "} catch (FormatException ex) {");
                                getData()
                                        .addLine(
                                                "throw new BlancoFixedLengthIOException(\""
                                                        + bundle
                                                                .getCsvReaderErr004(getLocationString(
                                                                        indexField,
                                                                        field
                                                                                .getNo(),
                                                                        field
                                                                                .getName(),
                                                                        field
                                                                                .getDescription()))
                                                        + "\" + ex.ToString(), ex);");
                                getData().addLine("}");
                            } else if (field.getType().equals("long")) {
                                getData().addLine("try {");
                                getData()
                                        .addLine(
                                                "record.Set"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "(Int64.Parse(tokenString.Trim()));");
                                getData().addLine(
                                        "} catch (FormatException ex) {");
                                getData()
                                        .addLine(
                                                "throw new BlancoFixedLengthIOException(\""
                                                        + bundle
                                                                .getCsvReaderErr005(getLocationString(
                                                                        indexField,
                                                                        field
                                                                                .getNo(),
                                                                        field
                                                                                .getName(),
                                                                        field
                                                                                .getDescription()))
                                                        + "\" + ex.ToString(), ex);");
                                getData().addLine("}");
                            } else if (field.getType()
                                    .equals("System.DateTime")) {
                                getData().addLine("try {");
                                getData()
                                        .addLine(
                                                "record.Set"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "(DateTime.ParseExact(tokenString.Trim(), fSimpleDateFormat"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + ", null));");
                                getData().addLine(
                                        "} catch (FormatException ex) {");
                                getData()
                                        .addLine(
                                                "throw new BlancoFixedLengthIOException(\""
                                                        + bundle
                                                                .getCsvReaderErr006(
                                                                        getLocationString(
                                                                                indexField,
                                                                                field
                                                                                        .getNo(),
                                                                                field
                                                                                        .getName(),
                                                                                field
                                                                                        .getDescription()),
                                                                        BlancoNameAdjuster
                                                                                .toClassName(field
                                                                                        .getName()))
                                                        + "\" + ex.ToString(), ex);");
                                getData().addLine("}");
                            } else if (field.getType().equals("decimal")) {
                                getData().addLine("try {");
                                getData()
                                        .addLine(
                                                "record.Set"
                                                        + BlancoNameAdjuster
                                                                .toClassName(field
                                                                        .getName())
                                                        + "(Convert.ToDecimal(tokenString.Trim()));");
                                getData().addLine(
                                        "} catch (FormatException ex) {");
                                getData()
                                        .addLine(
                                                "throw new BlancoFixedLengthIOException(\""
                                                        + bundle
                                                                .getCsvReaderErr007(getLocationString(
                                                                        indexField,
                                                                        field
                                                                                .getNo(),
                                                                        field
                                                                                .getName(),
                                                                        field
                                                                                .getDescription()))
                                                        + "\" + ex.ToString(), ex);");
                                getData().addLine("}");
                            } else {
                                getData().addLine(
                                        bundle.getNotSupportedType(field
                                                .getType()));
                            }

                        }

                        // SĂ̍ڂǂݐ؂Ƀf[^cĂȂƂmFB
                        getData().addLine("");
                        getData().addLine("if (reader.Read() >= 0) {");
                        getData().addLine(
                                "throw new BlancoFixedLengthIOException(\""
                                        + bundle.getCsvReaderErr009() + "\");");
                        getData().addLine("}");

                        getData().addLine("return record;");
                    }

                });

                addMethod(new MethodExpander("GetLineCounter") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine("ݏ̍sJE^Ԃ܂B");
                        getJavaDoc().addReturn("ݏ̍sJE^B");
                        setReturnType(new Type("long"));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("return fLineCounter;");
                    }
                });

                addMethod(new MethodExpander("Close") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        getJavaDoc().addLine(readerBundle.getCloseJavadoc01());
                        getJavaDoc().addLine(readerBundle.getCloseJavadoc02());
                        getJavaDoc().addException(
                                new Type(readerBundle.getCloseThrows01Type()),
                                readerBundle.getCloseThrows01Javadoc());
                        addException(new Type(readerBundle
                                .getCloseThrows01Type()));
                    }

                    // \bh̎
                    public void implement() {
                        getData().addLine("fReader.Close();");
                    }
                });
            }
        };

        ClassExpander.generateCsSource(classExpander, directoryTarget);
    }

    private String getLocationString(int indexField, String fieldNo,
            String fieldName, String fieldDescription) {
        return readerBundle.getGetlocationstringLine01("" + (indexField + 1),
                (fieldNo == null ? "" : bundle.getFieldNo(fieldNo) + " "),
                fieldName
                        + (fieldDescription == null ? "" : "/"
                                + fieldDescription));
    }
}
