/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.fixedlength.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoFixedLengthDotNet]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoFixedLengthDotNetResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoFixedLengthDotNetResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthDotNet]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoFixedLengthDotNetResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthDotNet");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoFixedLengthDotNetResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthDotNet]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoFixedLengthDotNetResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthDotNet", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoFixedLengthDotNetResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoFixedLengthDotNet]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoFixedLengthDotNetResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoFixedLengthDotNet", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[METAFILE_DISPLAYNAME]
     *
     * [t@C`(Œ蒷)] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(Œ蒷)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[META2XML.ELEMENT_COMMON]
     *
     * [blancofixedlength-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancofixedlength-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[META2XML.ELEMENT_LIST]
     *
     * [blancofixedlength-fieldList] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancofixedlength-fieldList";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[META2XML.ELEMENT_LIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR001]
     *
     * [{0}̏ɂĕsȏI[m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĕsȏI[m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR002]
     *
     * [{0}̏ɂĒ({1})Zl[&quot; + tokenString + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĒ({1})Zl[\" + tokenString + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR003]
     *
     * [{0}̏ɂĒ({1})l[&quot; + tokenString + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĒ({1})l[\" + tokenString + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR004]
     *
     * [{0}̏ɂĐl(int)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(int)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR005]
     *
     * [{0}̏ɂĐl(long)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr005(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(long)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR006]
     *
     * [{0}̏ɂė^ꂽ`[&quot; + fSimpleDateFormat{1} + &quot;]ł͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr006(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂė^ꂽ`[\" + fSimpleDateFormat{1} + \"]ł͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR007]
     *
     * [{0}̏ɂĐl(decimal)ƂĂ͉͂łȂ[&quot; + tokenString + &quot;]m܂B:] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_READER.ERR007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr007(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĐl(decimal)ƂĂ͉͂łȂ[\" + tokenString + \"]m܂B:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR007");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR007]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_READER.ERR009]
     *
     * [SĂ̗̌Œ蒷f[^𒴂f[^sɑ݂邱Ƃm܂B] (ja)<br>
     *
     * @return key[CSV_READER.ERR009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvReaderErr009() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SĂ̗̌Œ蒷f[^𒴂f[^sɑ݂邱Ƃm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_READER.ERR009");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_READER.ERR009]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_WRITER.ERR001]
     *
     * [{0}̏ɂĒ({1})Zl[&quot; + writeToken + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr001(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĒ({1})Zl[\" + writeToken + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_WRITER.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_WRITER.ERR002]
     *
     * [{0}̏ɂĒ({1})l[&quot; + writeToken + &quot;]m܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂĒ({1})l[\" + writeToken + \"]m܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_WRITER.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[CSV_WRITER.ERR011]
     *
     * [{0}̏ɂčڂnull^Ă邱Ƃm܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[CSV_WRITER.ERR011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getCsvWriterErr011(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}̏ɂčڂnull^Ă邱Ƃm܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CSV_WRITER.ERR011");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[CSV_WRITER.ERR011]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR001]
     *
     * [t@C`(Œ蒷) t@C`ID[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`(Œ蒷) t@C`ID[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR004]
     *
     * [t@C`ID[{0}] [{1}]́u^vw肳Ă܂Bu^vw肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr004(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vw肳Ă܂Bu^vw肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR005]
     *
     * [t@C`ID[{0}] [{1}]́u^vłAuvw肳Ă܂Bu^v̏ꍇ́uvw肵ĂB
: [yyyy/MM/dd HH:mm:ss]̂悤Ɏw肵܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr005(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vłAuvw肳Ă܂Bu^v̏ꍇ́uvw肵ĂB\n: [yyyy/MM/dd HH:mm:ss]̂悤Ɏw肵܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR006]
     *
     * [t@C`ID[{0}] [{1}]́u^vł͂܂񂪁Auvw肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr006(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́u^vł͂܂񂪁Auvw肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR007]
     *
     * [t@C`ID[{0}] [{1}]́uvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr007(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uvɕ̒l[{2}]^܂B0ȏ̐lݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR007");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR007]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[XML2JAVACLASS.ERR008]
     *
     * [t@C`ID[{0}] [{1}]́uvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr008(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "t@C`ID[{0}] [{1}]́uvɐƂďȂl[{2}]^܂B0ȏ̐ݒ肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR008");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[XML2JAVACLASS.ERR008]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[FIELD_NO]
     *
     * [ڔԍ[{0}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[FIELD_NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڔԍ[{0}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("FIELD_NO");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[FIELD_NO]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[NOT_SUPPORTED_TYPE]
     *
     * [// TODO: x: T|[gȂ^[{0}]^܂BXLbv܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[NOT_SUPPORTED_TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getNotSupportedType(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "// TODO: x: T|[gȂ^[{0}]^܂BXLbv܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("NOT_SUPPORTED_TYPE");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[NOT_SUPPORTED_TYPE]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoFixedLengthDotNet], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoFixedLengthDotNet]AL[[ANTTASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
