package blanco.plugin.fixedlength.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.doclisting.BlancoDocListingXml2CombinedXmlCsv;
import blanco.fixedlength.BlancoFixedLengthConstants;
import blanco.fixedlength.BlancoFixedLengthDotNetMeta2Xml;
import blanco.fixedlength.BlancoFixedLengthMeta2Xml;
import blanco.fixedlength.BlancoFixedLengthXml2CsClass;
import blanco.fixedlength.BlancoFixedLengthXml2JavaClass;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthResourceBundle;
import blanco.plugin.fixedlength.BlancoFixedLengthPlugin;
import blanco.plugin.fixedlength.BlancoFixedLengthPluginConstants;
import blanco.plugin.fixedlength.editors.BlancoFixedLengthPluginUtil;

public class BlancoFixedLengthGenerateAction {
    private static final BlancoFixedLengthResourceBundle fBundle = new BlancoFixedLengthResourceBundle();

    /**
     * blancoFixedLength Java\[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param runtimePackage
     *            ^CpbP[WBwnullŕ\B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoFixedLengthJavaSource(
            final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor,
            final String runtimePackage, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoFixedLengthConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoFixedLengthPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                BlancoFixedLengthPluginUtil
                                        .createFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                BlancoFixedLengthPluginUtil
                                        .createFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY
                                                        + BlancoFixedLengthConstants.VALUE_OBJECT_DIRECTORY);
                                final IFolder tempFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempValueObjectFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY
                                                        + BlancoFixedLengthConstants.VALUE_OBJECT_DIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                new BlancoFixedLengthMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                monitor.subTask("tH_쐬: blancotH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, workbenchMonitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask("Java\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("Java\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            new BlancoFixedLengthXml2JavaClass()
                                                    .process(
                                                            fileLook
                                                                    .getLocation()
                                                                    .toFile(),
                                                            runtimePackage,
                                                            tempValueObjectFolder
                                                                    .getLocation()
                                                                    .toFile(),
                                                            blancoTargetDirectory,
                                                            false);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: blancotH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoFixedLengthPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoFixedLengthPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoFixedLengthPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoFixedLengthPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * blancoFixedLength C#.NET\[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param runtimePackage
     *            ^CpbP[WBwnullŕ\B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoFixedLengthCsSource(
            final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor,
            final String runtimePackage, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoFixedLengthConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoFixedLengthPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                BlancoFixedLengthPluginUtil
                                        .createFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                BlancoFixedLengthPluginUtil
                                        .createFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY
                                                        + BlancoFixedLengthConstants.VALUE_OBJECT_DIRECTORY);
                                final IFolder tempFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempValueObjectFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(
                                                ifile,
                                                workbenchMonitor,
                                                "tmp"
                                                        + BlancoFixedLengthConstants.TARGET_SUBDIRECTORY
                                                        + BlancoFixedLengthConstants.VALUE_OBJECT_DIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoFixedLengthPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                new BlancoFixedLengthDotNetMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                monitor.subTask("tH_쐬: blanco.cstH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco.cs");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            workbenchMonitor);
                                }

                                monitor.subTask("tH_쐬: blanco.cs/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, workbenchMonitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask("C#.NET\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("C#.NET\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            new BlancoFixedLengthXml2CsClass()
                                                    .process(
                                                            fileLook
                                                                    .getLocation()
                                                                    .toFile(),
                                                            runtimePackage,
                                                            tempValueObjectFolder
                                                                    .getLocation()
                                                                    .toFile(),
                                                            blancoTargetDirectory);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: blanco.cstH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (BlancoFixedLengthPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoFixedLengthPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoFixedLengthPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoFixedLengthPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoFixedLengthPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}