/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.fixedlength.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.fixedlength.BlancoFixedLengthDotNetConstants;
import blanco.fixedlength.BlancoFixedLengthDotNetMeta2Xml;
import blanco.fixedlength.BlancoFixedLengthXml2CsClass;
import blanco.fixedlength.resourcebundle.BlancoFixedLengthDotNetResourceBundle;

/**
 * BlancoFixedLengthAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoFixedLengthDotNetTask extends
        AbstractBlancoFixedLengthDotNetTask {
    private final BlancoFixedLengthDotNetResourceBundle fBundle = new BlancoFixedLengthDotNetResourceBundle();

    /**
     * AntTask̏s܂B
     * 
     * ̃\bh ېeNXłAbstractBlancoFixedLengthTaskNXĂяo܂B
     * 
     * @throws IllegalArgumentException
     *             e͒lȌꍇɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoFixedLengthDotNetConstants.PRODUCT_NAME
                + " (" + BlancoFixedLengthDotNetConstants.VERSION + ")");

        try {
            final File blancoTmpDirectory = new File(getTmpdir()
                    + BlancoFixedLengthDotNetConstants.TARGET_SUBDIRECTORY);
            blancoTmpDirectory.mkdirs();

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            new BlancoFixedLengthDotNetMeta2Xml()
                    .processDirectory(
                            fileMetadir,
                            getTmpdir()
                                    + BlancoFixedLengthDotNetConstants.TARGET_SUBDIRECTORY);

            final File tempValueObjectFolder = new File(getTmpdir()
                    + BlancoFixedLengthDotNetConstants.TARGET_SUBDIRECTORY
                    + BlancoFixedLengthDotNetConstants.VALUE_OBJECT_DIRECTORY);
            tempValueObjectFolder.mkdirs();

            final File[] fileTmp = blancoTmpDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoFixedLengthXml2CsClass().process(fileTmp[index],
                            getRuntimepackage(), tempValueObjectFolder,
                            new File(getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}
