/*
 * This code is generated by blanco Framework.
 * blancoFixedLengthŗps[eBeBNX<br>
 */
package blanco.sample.fixedlength.util;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import blanco.sample.fixedlength.io.BlancoFixedLengthIOException;

/**
 * blancoFixedLengthŗps[eBeBNX<br>
 * ̃t@Cblanco Frameworkɂ莩Ă܂B
 */
public class BlancoFixedLengthRuntimeUtil {
    /**
     * ^ꂽReader w̒̌Œ蒷g[No܂
     *
     * @param argReader ^ꂽ[_
     * @param argTokenLength ǂݍ݂҂g[N̒B
     * @param argEncoding ̃GR[fBOB
     * @return oꂽŒ蒷g[NB󋵂ɂĂ͊҂钷Ƃ͈قȂ钷̕񂪖߂܂B
     * @throws BlancoFixedLengthIOException ڐȂȂǗ^ꂽɊւOꍇB
     * @throws IOException o͗OꍇB
     */
    public static String readToken(final Reader argReader, final int argTokenLength, final String argEncoding) throws BlancoFixedLengthIOException, IOException {
        if (argReader == null) {
            throw new IllegalArgumentException("readToken\bh̓̓p[^̃[_null^܂B");
        }
        if (argTokenLength <= 0) {
            throw new IllegalArgumentException("readToken\bh̒Ƃ0ȉ^܂B1ȏ̒l^ĂB");
        }

        final StringBuffer buffer = new StringBuffer();
        for (;;) {
            final int iRead = argReader.read();
            if (iRead < 0) {
                // I[ɓB܂Bf܂B
                break;
            } else {
                buffer.append((char) iRead);
            }

            byte[] bytesLengthCheck = null;
            if (argEncoding == null) {
                bytesLengthCheck = buffer.toString().getBytes();
            } else {
                bytesLengthCheck = buffer.toString().getBytes(argEncoding);
            }

            if (bytesLengthCheck.length >= argTokenLength) {
                // Œ蒷g[N҂钷ɓB܂͊҂钷𒴂܂B
                // f܂B
                break;
            }
        }
        return buffer.toString();
    }

    /**
     * ^ꂽw̒܂ŉEpfBO܂B
     *
     * @param argSource ͕B
     * @param argLength ڕWƂg[^oCgB
     * @param argPadChar ߂ۂɗppfBOB
     * @param argEncoding oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB
     * @return ڕWƂȂoCgɉHꂽ̕B
     */
    public static String padRight(final String argSource, final int argLength, final char argPadChar, final String argEncoding) {
        if (argSource == null) {
            throw new IllegalArgumentException("padRight͕̓ null^܂B");
        }

        String result = argSource;
        for (;;) {
            if (getBytesLength(result, argEncoding) >= argLength) {
                break;
            }

            // ꕶ₵Ă܂B
            result = result + argPadChar;
        }
        return result;
    }

    /**
     * ^ꂽw̒܂ōpfBO܂B
     *
     * @param argSource ͕B
     * @param argLength ڕWƂg[^oCgB
     * @param argPadChar ߂ۂɗppfBOB
     * @param argEncoding oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB
     * @return ڕWƂȂoCgɉHꂽ̕B
     */
    public static String padLeft(final String argSource, final int argLength, final char argPadChar, final String argEncoding) {
        if (argSource == null) {
            throw new IllegalArgumentException("padLeft͕̓ null^܂B");
        }

        String result = argSource;
        for (;;) {
            if (getBytesLength(result, argEncoding) >= argLength) {
                break;
            }

            // ꕶ₵Ă܂B
            result = argPadChar + result;
        }
        return result;
    }

    /**
     * ^ꂽ̃oCg擾܂B
     *
     * @param argSource ͕B
     * @param argEncoding oCgZo邽߂̃GR[fBOBnullw̏ꍇɂ̓ftHgGR[fBOB
     * @return ͕̃oCgB
     */
    private static int getBytesLength(final String argSource, final String argEncoding) {
        if (argSource == null) {
            throw new IllegalArgumentException("getBytesLength͕̓ null^܂B");
        }

        if (argEncoding == null) {
            return argSource.getBytes().length;
        } else {
            try {
                return argSource.getBytes(argEncoding).length;
            } catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("T|[gȂGR[fBO[" + argEncoding + "]w肳܂B" + ex.toString());
            }
        }
    }
}
