package blanco.sample.fixedlength.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;

import junit.framework.TestCase;
import blanco.sample.fixedlength.record.SampleFixedLengthFixedLengthRecord;

public class SampleFixedLengthFixedLengthTest extends TestCase {
    public void testSample() throws Exception {
        new File("tmp").mkdirs();
        SampleFixedLengthFixedLengthWriter writer = new SampleFixedLengthFixedLengthWriter(
                new BufferedWriter(new FileWriter("tmp/aaa.txt")));
        try {
            final SampleFixedLengthFixedLengthRecord recored = new SampleFixedLengthFixedLengthRecord();
            recored.setField5(new Date());
            writer.writeRecord(recored);
            writer.writeRecord(recored);
            writer.writeRecord(recored);
        } finally {
            writer.close();
        }

        final SampleFixedLengthFixedLengthReader reader = new SampleFixedLengthFixedLengthReader(
                new BufferedReader(new FileReader("tmp/aaa.txt")));
        try {
            for (;;) {
                final SampleFixedLengthFixedLengthRecord record = reader
                        .readRecord();
                if (record == null) {
                    break;
                }
                System.out.println(record.getField1());
            }
        } finally {
            reader.close();
        }
    }
}
