/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.db.definition.QueryField;
import blanco.db.definition.TableField;

/**
 * @author Yasuo Nakanishi
 */
public class SelectQuery extends AbstractQuery {
    private String _strScrollInterface = "forward_only";

    private boolean _enableUpdatableInterface = false;

    private final List _fieldList = new ArrayList();

    public SelectQuery(final String name) {
        super(name);
    }

    public void addField(final QueryField field) {
        _fieldList.add(field);
    }

    public TableField getField(final int index) {
        return (TableField) _fieldList.get(index);
    }

    public int getFieldCount() {
        return _fieldList.size();
    }

    public Iterator getFieldIterator() {
        return _fieldList.iterator();
    }

    public String getScrollInterface() {
        return _strScrollInterface;
    }

    public void setScrollInterface(final String strScrollInterface) {
        _strScrollInterface = strScrollInterface;
    }

    public boolean isEnableUpdatableInterface() {
        return _enableUpdatableInterface;
    }

    public void setEnableUpdatableInterface(
            final boolean enableUpdatableInterface) {
        _enableUpdatableInterface = enableUpdatableInterface;
    }
}