/*
 * blancoCodeGenerator
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander;

/**
 * blancoCodeGenerator̃[eBeBNXB
 * 
 * @author Yasuo Nakanishi (1st version)
 * @author IGA Tosiki (2nd version)
 */
public class BlancoCodeGeneratorUtil {
    /**
     * ^ꂽ^ blancoCgƂĐKȌ^ւƉH܂B
     * 
     * @param argTypeName
     *            HO(pbP[W܂)^B
     * @return H(pbP[W܂)^B
     */
    public static final String normalizeTypeName(final String argTypeName) {
        String type = argTypeName;
        if (type.endsWith("[]")) {
            // blancoCgł͔z̓o[IuWFNg̃tB[hƂȂ܂B
            // ̃\bhoRƂ͕ʌoHɂĔz̏`BĂB
            type = type.substring(0, type.length() - 2);
        }

        if (type.equals("String")) {
            // blancoCodeGenerator StringȂǂƏȗĂ삵Ă܂B
            // ƌ݊邽߂ɁAނ𓾂ǂݑւs܂B
            // ̓Ǒւ JavaƂȂ܂BC#.NET̏ꍇɂ System.StringƖĂB
            type = "java.lang.String";
        }

        return type;
    }
}
