/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIterator;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * VOfalsełꍇɂ̂݁Ã\bh͍쐬܂B
 * 
 * @author Yasuo Nakanishi
 */
public class NextMethod extends MethodExpander {
    private BlancoDbObjectStorage fStorage = null;

    private QueryIterator fIterator = null;

    public NextMethod(final BlancoDbObjectStorage storage,
            final QueryIterator iterator) {
        super("next");

        if (iterator == null) {
            throw new IllegalArgumentException(
                    "NextMethod̃RXgN^ɃCe[^Ƃnull^܂B");
        }

        this.fStorage = storage;
        this.fIterator = iterator;
    }

    /**
     * VOLłꍇɂ protectedƂ܂B
     */
    protected Scope getScope() {
        if (fIterator.isSingle()) {
            return Scope.PROTECTED;
        } else {
            return Scope.PUBLIC;
        }
    }

    public void setupSignature() {
        setReturnType(new Type(boolean.class));

        // ^CpbP[W̕ωɑΉB
        String runtimePackage = fStorage.getSetting().getRootNameSpace();
        if (fStorage.getSetting().getRuntimePackage() != null) {
            runtimePackage = fStorage.getSetting().getRuntimePackage();
        }

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("J[\݂̈ʒu1sֈړ܂B");
        getJavaDoc().addLine("");
        if (fIterator.isSingle()) {
            getJavaDoc().addLine("VOLȂ̂ŃXR[vprotectedƂ܂B<br>");
        }
        getJavaDoc().addReturn("V݂̍sLȏꍇtrueAȏ̍sȂꍇfalseB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (fStorage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        implementor.addLine("if (fResultSet == null) {");
        implementor.addLine("executeQuery();");
        implementor.addLine("}");

        implementor.addLine("");
        implementor.addLine("try {");
        implementor.addLine("return fResultSet.next();");
        implementor.addLine("} catch (SQLException ex) {");
        implementor.addLine("throw BlancoDbUtil.convertToBlancoException(ex);");
        implementor.addLine("}");
    }
}