/*
 * blancoDb
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.definition.QueryInvoker;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteUpdateMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryInvoker fInvoker = null;

    public ExecuteUpdateMethod(final BlancoDbObjectStorage storage,
            final QueryInvoker invoker) {
        super("executeUpdate");
        this.storage = storage;
        this.fInvoker = invoker;
    }

    /**
     * VOLłꍇɂ protectedƂ܂B
     */
    protected Scope getScope() {
        if (fInvoker.isSingle()) {
            return Scope.PROTECTED;
        } else {
            return Scope.PUBLIC;
        }
    }

    public void setupSignature() {
        final Type resultType = new Type(int.class);
        setReturnType(resultType);

        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final Type integrityConstraintException = new Type(runtimePackage
                + ".exception.IntegrityConstraintException");
        getJavaDoc().addException(integrityConstraintException,
                "f[^x[XᔽꍇB");
        addException(integrityConstraintException);

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        getJavaDoc().addException(deadlockException, "f[^x[XfbhbNꍇB");
        addException(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        getJavaDoc().addException(timeoutException, "f[^x[X^CAEgꍇB");
        addException(timeoutException);

        getJavaDoc().addException(new Type("java.sql.SQLException"),
                "SQLOꍇB");
        addException(new Type("java.sql.SQLException"));

        getJavaDoc().addLine("SQLs܂B");

        if (fInvoker.isSingle()) {
            getJavaDoc().addLine("");
            getJavaDoc().addLine("VOLȂ̂ŃXR[vprotectedƂ܂B<br>");
            getJavaDoc().addLine(
                    "̃\bh̑ executeSingleUpdate\bh𗘗pĂB<br>");
        }

        getJavaDoc().addReturn("ꂽs");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor
                .addLine("// PreparedStatement擾̏ԂȂ̂ŁAPreparedStatement.executeUpdate()sɐ旧prepareStatement()\bhĂяoĎ擾܂B");
        implementor.addStatement("prepareStatement()");
        implementor.addLine("}");

        implementor.emptyLine();

        // O܂߂ēWJ܂B
        implementor.addLine("try {");
        implementor.addLine("return fStatement.executeUpdate();");
        implementor.addLine("} catch (SQLException ex) {");
        implementor.addLine("throw BlancoDbUtil.convertToBlancoException(ex);");
        implementor.addLine("}");
    }
}