/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.calc.parser.block;

/**
 * \p̒lƎۂ̒lƂ}bsO܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCalcParserValueMapping {
    private String[] source = null;

    private String target = null;

    public BlancoCalcParserValueMapping(String[] source, String target) {
        this.source = source;
        this.target = target;
    }

    public void setSource(String[] args) {
        source = args;
    }

    public String[] getSource() {
        return source;
    }

    public String getTarget() {
        return target;
    }

    /**
     * }bsOs܂B}bsOsꍇɂnull߂܂B
     * 
     * @param value
     *            ͒lB
     * @return }bsOɃqbgϊ̒l߂܂B}bsOɃqbgȂꍇɂ͓͒l̂܂ܖ߂܂B
     */
    private String mapping(final String value) {
        if (source == null) {
            return null;
        }
        for (int index = 0; index < source.length; index++) {
            if (source[index].equals(value)) {
                return target;
            }
        }
        return null;
    }

    /**
     * l̃}bsOs܂B}bsOłȂꍇɂ ͒l̂܂ܖ߂܂B
     * 
     * @param value
     *            }bsÕ}b`Os͒lB
     * @param mappings
     *            }bsO\B
     * @return }bsO̒lB}bsOsȂꍇɂ͓͒l̂́B
     */
    public static final String mapping(final String value,
            final BlancoCalcParserValueMapping[] mappings) {
        if (mappings == null) {
            return value;
        }
        for (int index = 0; index < mappings.length; index++) {
            String result = mappings[index].mapping(value);
            if (result != null) {
                return result;
            }
        }
        return value;
    }
}
