/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.IgType;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki IGA
 */
public class GetStatementMethod extends MethodExpander {
    protected boolean fIsCallableStatement = false;

    public GetStatementMethod(final BlancoDbObjectStorage storage,
            final boolean isCallableStatement) {
        super("getStatement");
        fIsCallableStatement = isCallableStatement;
    }

    public void setupSignature() {
        String resultType = "java.sql.PreparedStatement";
        if (fIsCallableStatement == false) {
        } else {
            resultType = "java.sql.CallableStatement";
        }
        setReturnType(new IgType(resultType));

        getJavaDoc().addLine("Xe[gg (" + resultType + ") 擾܂B");
        getJavaDoc().addLine("@deprecated {IStatement͊O璼ڗpKv͂܂B");
        getJavaDoc().addReturn("IɗpĂ " + resultType + "IuWFNg");
    }

    public void implement() {
        getData().addLine("return fStatement;");
    }
}