/*
 * BlancoDbDefaultGenerator.
 * ƂT^IBlancoDbGenerator
 * 
 * Copyright (C) 2005 tosiki.iga@nifty.ne.jp
 */

package blanco.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.db.collector.BlancoDbCollector;
import blanco.db.collector.BlancoDbDatabaseConnection;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.definition.BlancoDbDefinition;
import blanco.db.generator.BlancoDbGenerator;

/**
 * blancoDb𗘗pۂ̂Ƃ{IGenerator܂B
 */
public abstract class BlancoDbXml2JavaClass implements IBlancoDbProgress {
    private boolean isLogging = false;

    public void setLogging(final boolean arg) {
        isLogging = arg;
    }

    /**
     * łʓI blancoDbGenerators܂B
     * 
     * @param jdbcDriver
     *            JDBChCoNX
     * @param jdbcUrl
     *            JDBCڑURI
     * @param jdbcUsername
     *            JDBC[U
     * @param jdbcPassword
     *            JDBCpX[h
     * @param blancoSqlDirectory
     *            blancoSqli[ꂽfBNg.nullw̍ۂɂ͏XLbv܂.
     * @param rootPackage
     *            blancoɐݒ肷郋[gpbP[W
     * @param runtimePackage
     *            blancoɐݒ肷郉^CpbP[WBnullȂftHgɏóB
     * @param statementTimeout
     *            Xe[gg^CAEglB
     * @return IȂtrue, ُIȂfalse
     * @throws BlancoDbException
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     * @throws SQLException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    public void process(final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoSqlDirectory, final String rootPackage,
            String runtimePackage, final String statementTimeout,
            final String blancoTargetSourceDirectory) throws SQLException,
            SAXException, IOException, ParserConfigurationException,
            ClassNotFoundException, TransformerException {
        System.out.println(BlancoDbConstants.PRODUCT_NAME + " ("
                + BlancoDbConstants.VERSION + ") \[XR[h: Jn.");

        if (BlancoStringUtil.null2Blank(runtimePackage).trim().length() == 0) {
            runtimePackage = null;
        }

        final BlancoDbSetting setting = new BlancoDbSetting();
        setting.setJdbc(connDef);
        setting.setLogging(isLogging);
        if (blancoTargetSourceDirectory != null) {
            setting.setWorkDirectory(blancoTargetSourceDirectory);
        }
        if (runtimePackage != null) {
            setting.setRuntimePackage(runtimePackage);
        }

        if (BlancoStringUtil.null2Blank(statementTimeout).length() > 0) {
            try {
                setting.setStatementTimeout(Integer.parseInt(statementTimeout));
            } catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Xe[gg^CAEglƂĎw肳ꂽl["
                        + statementTimeout + "]͐lƂĉ͂ł܂łBf܂B:"
                        + ex.toString());
            }
        }

        final BlancoDbDatabaseConnection dbInfoCollector = new BlancoDbDatabaseConnection();
        try {
            dbInfoCollector.connect(connDef);
            dbInfoCollector.getDatabaseVersionInfo();
            setting.setDriverName(dbInfoCollector.getDriverName());

            setting.setRootNameSpace(rootPackage);

            if (blancoSqlDirectory != null) {
                // w肪ꍇɂ̂ SQL`t@Ci[fBNg܂B

                // ValueObjecti[fBNg쐬܂B
                new File(blancoSqlDirectory.getAbsolutePath() + "/valueobject")
                        .mkdirs();

                final File[] fileSettingXml = blancoSqlDirectory.listFiles();
                for (int index = 0; index < fileSettingXml.length; index++) {
                    if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                        // t@C̊gq xml ł̂̂ݏ܂B
                        continue;
                    }
                    if (progress(index + 1, fileSettingXml.length,
                            fileSettingXml[index].getName()) == false) {
                        break;
                    }

                    // ^͖ j܂B
                    BlancoDbMetadata metadata = new BlancoDbMetadata();
                    parseAndProcessBlancoDbSettingFile(fileSettingXml[index],
                            metadata);

                    // ̓t@Cɍs܂B
                    generate(metadata, setting, dbInfoCollector, rootPackage,
                            new File(blancoSqlDirectory.getAbsolutePath()
                                    + "/valueobject"));
                }
            }

        } finally {
            dbInfoCollector.close();
            System.out.println("\[XR[h: I.");
        }
    }

    /**
     * s܂B
     * 
     * @param metadata
     * @param setting
     * @param conn
     * @param rootPackage
     * @param outputDirectory
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     * @throws TransformerException
     */
    private void generate(final BlancoDbMetadata metadata,
            final BlancoDbSetting setting,
            final BlancoDbDatabaseConnection conn, final String rootPackage,
            final File outputDirectory) throws SQLException, SAXException,
            IOException, ParserConfigurationException, TransformerException {
        final BlancoDbCollector collector = new BlancoDbCollector();
        final BlancoDbDefinition definition = collector.collect(metadata, conn);

        final BlancoDbGenerator generator = new BlancoDbGenerator(setting);
        generator.setup(definition, rootPackage, outputDirectory);
        generator.generate();
    }

    /**
     * BlancoDb SQL`t@Cp[XāAKv΃^ɒǉ܂B ̃\bh OĂяoꍇ܂B
     * 
     * @param fileSettingXml
     *            ͂ƂȂblancoDbݒt@C
     * @param metadata
     *            o͂ƂȂ郁^f[^
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws SAXException
     */
    private void parseAndProcessBlancoDbSettingFile(final File fileSettingXml,
            final BlancoDbMetadata metadata) throws IOException,
            ParserConfigurationException, SAXException {
        System.out.println("t@C[" + fileSettingXml.getAbsolutePath()
                + "]܂");

        final DocumentBuilderFactory documentFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex1) {
            System.err.println("hLg쐬ɗO܂.:" + ex1.toString());
            ex1.printStackTrace();
            throw ex1;
        }
        try {
            document = documentBuilder.parse(fileSettingXml);
        } catch (SAXException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            throw e;
        } catch (IOException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            throw e;
        }
        final Element blancoDbElement = document.getDocumentElement();
        if (blancoDbElement == null) {
            System.out.println("blanco-db[gm[h܂");
            return;
        }
        final NodeList rootNodeList = blancoDbElement.getChildNodes();
        if (rootNodeList == null) {
            return;
        }
        metadata.addXml(fileSettingXml);
    }
}