/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.Iterator;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.definition.QueryField;
import blanco.db.definition.QueryIterator;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.GetStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod2;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.ResultSetField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class QueryIteratorClass extends ClassExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryIterator _iterator = null;

    public QueryIteratorClass(final BlancoDbObjectStorage storage,
            final Type type, final QueryIterator iterator) {
        super(type);
        _iterator = iterator;
        this.storage = storage;

        getJavaDoc().addLine(type.getName() + "NX (QueryIterator)B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("^SQLbsOĊeANZT񋟂܂B<br>");
        if (iterator.isSingle()) {
            getJavaDoc().addLine("VO: L (҂鏈1)<br>");
        }
        if (iterator.getScrollInterface() != null) {
            getJavaDoc().addLine(
                    "XN[: " + iterator.getScrollInterface() + "<br>");
        }
        if (iterator.isEnableUpdatableInterface()) {
            getJavaDoc().addLine("XV\: L<br>");
        }
    }

    protected void expandClassStruct() {
        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        // addImport(new Type(runtimePackage
        // + ".exception.IntegrityConstraintException"));

        // BlancoDbUtil͏ɃC|[g܂B
        addImport(new Type(runtimePackage + ".util.BlancoDbUtil"));

        addField(new ConnectionField());
        addField(new StatementField("java.sql.PreparedStatement"));
        addField(new ResultSetField());

        if (storage.getSetting().isLogging()) {
            addImport(new Type("org.apache.commons.logging.LogFactory"));
            addField(new LogField(getName()));
        }

        final Type _type = new Type(storage.getSetting().getRootNameSpace()
                + ".query", BlancoNameAdjuster.toClassName(_iterator.getName())
                + "Iterator");

        addMethod(new QueryConstructor(_type));

        addMethod(new GetQueryMethod(_iterator.getQuery()));

        addMethod(new PrepareStatementMethod(storage));
        addMethod(new PrepareStatementMethod2(storage, _iterator));
        // p[^ꍇɂ̂ bind\bh𐶐܂B
        Iterator iParameter = _iterator.getInParameterIterator();
        if (iParameter.hasNext()) {
            addMethod(new SetInputParameterMethod(storage, _iterator));
        }

        addMethod(new ExecuteQueryMethod(storage, _iterator));

        addMethod(new NextMethod(storage, _iterator));

        // J[\true̍ۂɂ previous\bhȂǂ
        // XN[J[\֘A\bhǉ
        // O: J[\truȅꍇɂ̓VOfalse
        if (_iterator.getScrollInterface().equals("forward_only") == false) {
            addMethod(new PreviousMethod(storage, _iterator));
            addMethod(new FirstMethod(storage, _iterator));
            addMethod(new LastMethod(storage, _iterator));

            addMethod(new AbsoluteMethod(storage, _iterator));
            addMethod(new RelativeMethod(storage, _iterator));
        }

        final Type rowObjectType = new Type(storage.getSetting()
                .getRootNameSpace()
                + ".row", BlancoNameAdjuster.toClassName(_iterator.getName())
                + "Row");

        addMethod(new GetRowMethod(storage, rowObjectType, _iterator));

        addMethod(new GetStatementMethod(storage, false));

        addMethod(new GetResultSetMethod(storage));

        if (_iterator.isSingle()) {
            addMethod(new GetSingleRowMethod(storage, rowObjectType, _iterator));
        }

        if (_iterator.isSingle() == false) {
            addMethod(new GetListMethod(_iterator));
        }

        // XV\̏ꍇɂ݂̂̐łB
        if (_iterator.isEnableUpdatableInterface()) {
            // ʂ̗̐Aupdate\bh𐶐
            boolean isAllFieldReadOnly = true;
            Iterator fieldIterator = _iterator.getFieldIterator();
            QueryField field = null;
            while (fieldIterator.hasNext()) {
                field = (QueryField) fieldIterator.next();

                // ResultSetMetaData Writableł ȏ͏Ƀ\bh𐶐܂B
                if (field.getWritable()) {
                    addMethod(new UpdateObjectMethod(storage, _iterator, field));
                    isAllFieldReadOnly = false;
                }
            }
            if (isAllFieldReadOnly == false) {
                addMethod(new UpdateRowMethod(storage, _iterator));
            }
        }

        addMethod(new CloseMethod(storage));

        addMethod(new Finalize(storage, getName()));
    }
}