/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.meta2xml.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.meta2xml.BlancoMeta2XmlConstants;
import blanco.meta2xml.BlancoMeta2XmlProcessMeta2Xml;
import blanco.meta2xml.BlancoMeta2XmlXml2JavaClass;

public class BlancoMeta2XmlProcessTask extends
        AbstractBlancoMeta2XmlProcessTask {
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoMeta2XmlConstants.PRODUCT_NAME + " ("
                + BlancoMeta2XmlConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoMeta2XmlProcessMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY);

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File fileWorkdir = new File(getTmpdir()
                    + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY);
            final File[] fileMeta2 = fileWorkdir.listFiles();
            if (fileMeta2 == null) {
                throw new IllegalArgumentException("[NfBNg["
                        + fileWorkdir.getAbsolutePath() + "]̃t@Cꗗ̎擾Ɏs܂B");
            }

            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoMeta2XmlXml2JavaClass().process(fileMeta2[index],
                        new File(getTargetdir()));
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
