/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.Iterator;

import blanco.db.definition.QueryCaller;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.GetStatementMethod;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class QueryCallerClass extends ClassExpander {
    private BlancoDbObjectStorage storage = null;

    private QueryCaller _caller = null;

    public QueryCallerClass(final BlancoDbObjectStorage storage,
            final Type type, final QueryCaller caller) {
        super(type);
        _caller = caller;
        this.storage = storage;

        getJavaDoc().addLine(type.getName() + "NX (QueryCaller)B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("ďo^SQLbsOĊeANZT񋟂܂B<br>");
    }

    protected void expandClassStruct() {
        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        addImport(new Type(runtimePackage
                + ".exception.IntegrityConstraintException"));

        // BlancoDbUtil͏ɃC|[g܂B
        addImport(new Type(runtimePackage + ".util.BlancoDbUtil"));

        addField(new ConnectionField());
        addField(new StatementField("java.sql.CallableStatement"));

        if (storage.getSetting().isLogging()) {
            addImport(new Type("org.apache.commons.logging.LogFactory"));
            addField(new LogField(getName()));
        }

        addMethod(new QueryConstructor(getType()));

        addMethod(new GetQueryMethod(_caller.getQuery()));

        addMethod(new PrepareCallMethod(storage));
        addMethod(new PrepareCallMethod2(storage, _caller));

        addMethod(new SetCallerInputParameterMethod(storage, _caller));

        addMethod(new ExecuteMethod(storage));

        final Iterator ite = _caller.getOutParameterIterator();
        while (ite.hasNext()) {
            final Value val = (Value) ite.next();
            addMethod(new GetCallerOutputParameterMethod(storage, _caller, val));
        }

        addMethod(new GetStatementMethod(storage, true));

        addMethod(new CloseMethod(storage));

        addMethod(new Finalize(storage, getName()));
    }
}