/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sax;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.sax.SAXResult;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.sax.util.BlancoSaxUtil;

/**
 * ͗pXML͂ċۉSAXC^[̃eXgNX𐶐܂B<br>
 * ̃NXł́AConcreteSaxSerializer𐶐܂B<br>
 * <br>
 * ͂͗pXMLt@ĆAӓIȂ̂܂B_ł ȂIȂ̂ɂȂ܂B<br>
 * 1: ͗pXML̃Agr[gׂ͂Ďw肳ė̂Ɖ肵܂B<br>
 * 2: قȂKwɂēÕGeBeB݂Ȃ̂Ɖ肵܂B<br>
 * Ql:http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/org/xml/sax/ContentHandler.html<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoSaxXml2SerializerTest {
    /**
     * eXgp̃Gg|Cg
     * 
     * @param args
     */
    public static void main(String[] args) {
        try {
            new BlancoSaxXml2SerializerTest().process(new File(
                    BlancoSaxXml2Handler.MAIN_INPUT_FILENAME), "blanco",
                    "blanco.plugin.soap.concretesax",
                    "BlancoSoapBlancoFwSerializer");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * \[XR[hs܂B
     * 
     * @param sourceFile
     * @param targetDirectory
     * @param packageName
     * @param className
     * @throws IOException
     */
    public void process(final File sourceFile, final String targetDirectory,
            final String packageName, final String className)
            throws IOException {
        // Java\[XR[h𐶐̂߂̐ݒ
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(targetDirectory);
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addTest(getClassExpander(sourceFile, packageName,
                className));
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }

    /**
     * ̃NXWJs܂B
     * 
     * @param sourceFile
     * @param packageName
     * @param className
     * @return
     */
    private ClassExpander getClassExpander(final File sourceFile,
            final String packageName, final String className) {
        return new ClassExpander(new Type(packageName, className + "Test")) {
            protected void expandClassStruct() {
                addFileComment(className + "ۉSAXNXeXgNX<br>");
                getJavaDoc().addLine(className + "ۉSAXNXeXgNX<br>");
                getJavaDoc()
                        .addLine("SAX𗘗pXMLobsONX̃eXgNXłB<br>");
                getJavaDoc().addLine(
                        "̃NX͉͗pXMLt@C͂ƂċۉSAXNXƂĐ܂B<br>");
                getJavaDoc().addLine("̃\[XR[hblancoIgɂ@BIɎĂ܂B");
                setSuperClass(new Type("junit.framework.TestCase"));

                addMethod(new MethodExpander("testSerializer") {
                    // \bh̃VOj`w
                    public void setupSignature() {
                        addUsingType(new Type("java.io.BufferedOutputStream"));
                        // addUsingType(new
                        // Type("java.io.FileNotFoundException"));
                        addUsingType(new Type("java.io.FileOutputStream"));
                        addUsingType(new Type("java.io.IOException"));
                        addUsingType(new Type("java.io.OutputStream"));
                        // addUsingType(new
                        // Type("javax.xml.transform.TransformerConfigurationException"));
                        addUsingType(new Type("junit.framework.TestCase"));
                        // addUsingType(new Type("org.xml.sax.SAXException"));

                        addException(new Type("java.lang.Exception"));
                    }

                    public void implement() {
                        getData().addLine("OutputStream outStream = null;");
                        getData().addLine("try {");
                        getData()
                                .addLine(
                                        "outStream = new BufferedOutputStream(new FileOutputStream(\"output.xml\"));");
                        getData().addLine(
                                className + " serializer = new " + className
                                        + "(outStream);");
                        getData().addLine("serializer.startDocument();");

                        SAXResult result = new SAXResult(new ContentHandler() {
                            public void endDocument() throws SAXException {
                            }

                            public void startDocument() throws SAXException {
                            }

                            public void characters(char[] ch, int start,
                                    int length) throws SAXException {
                                if (length > 0) {
                                    getData()
                                            .addLine(
                                                    "serializer.characters(\""
                                                            + BlancoJavaSourceUtil
                                                                    .escapeStringAsJavaSource(new String(
                                                                            ch,
                                                                            start,
                                                                            length))
                                                            + "\");");
                                }
                            }

                            public void ignorableWhitespace(char[] arg0,
                                    int arg1, int arg2) throws SAXException {
                            }

                            public void endPrefixMapping(String arg0)
                                    throws SAXException {
                            }

                            public void skippedEntity(String arg0)
                                    throws SAXException {
                            }

                            public void setDocumentLocator(Locator arg0) {
                            }

                            public void processingInstruction(String arg0,
                                    String arg1) throws SAXException {
                            }

                            public void startPrefixMapping(String arg0,
                                    String arg1) throws SAXException {
                            }

                            public void startElement(String arg0, String arg1,
                                    String arg2, Attributes atts)
                                    throws SAXException {
                                String lineStatement = "serializer.startElement"
                                        + BlancoNameAdjuster.toClassName(arg2)
                                        + "(";
                                for (int index = 0; index < atts.getLength(); index++) {
                                    if (index != 0) {
                                        lineStatement += ", ";
                                    }
                                    lineStatement += "\""
                                            + atts.getValue(index) + "\"";
                                }
                                lineStatement += ");";
                                getData().addLine(lineStatement);
                            }

                            public void endElement(String arg0, String arg1,
                                    String arg2) throws SAXException {
                                getData().addLine(
                                        "serializer.endElement"
                                                + BlancoNameAdjuster
                                                        .toClassName(arg2)
                                                + "();");
                            }
                        });

                        BlancoSaxUtil.doTransform(sourceFile, result);

                        getData().addLine("serializer.endDocument();");
                        getData().addLine("outStream.flush();");
                        getData().addLine("} finally {");
                        getData().addLine("try {");
                        getData().addLine("if (outStream != null) {");
                        getData().addLine("outStream.close();");
                        getData().addLine("}");
                        getData().addLine("} catch (IOException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("}");
                        getData().addLine("}");
                    }
                });
            }
        };
    }
}
