/**
 * ̃NX͕ʃv_Ng\B
 */
package blanco.db.common;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import blanco.commons.sql.format.BlancoSqlFormatter;
import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.resourcebundle.BlancoDbCommonResourceBundle;
import blanco.db.common.stringgroup.BlancoDbDriverNameStringGroup;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.util.BlancoDbXmlSerializer;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.dbmetadata.BlancoDbMetaDataTable;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataTableStructure;

/**
 * [Vif[^x[X瓾\ƂɁAP\ANZT̂߂XMLԃt@C𐶐܂B
 * 
 * [Vif[^x[X烁^ô̂́ÃNXł͂ȂAʂ̃v_Ng blancoDbMetaDataS܂B
 */
public abstract class BlancoDbTableMeta2Xml implements IBlancoDbProgress {
    /**
     * P\̃NXɕtvtBbNXB
     */
    public static final String CLASS_PREFIX = "Simple";

    /**
     * e탊\[XohB
     */
    private final BlancoDbCommonResourceBundle fBundle = new BlancoDbCommonResourceBundle();

    /**
     * blancoDbɊւݒB
     */
    private BlancoDbSetting fDbSetting = null;

    /**
     * SQLtH[}bg邩ǂB
     * 
     * 2006.12.01_ł̓ftHg falseƂ܂B
     */
    private boolean fFormatSql = false;

    /**
     * SQLtH[}bg邩ǂB
     * 
     * @param argFormatSql
     */
    public void setFormatSql(final boolean argFormatSql) {
        fFormatSql = argFormatSql;
    }

    /**
     * [Vif[^x[X瓾\ƂɁAP\ANZT̂߂XMLԃt@C𐶐܂B
     * 
     * [Vif[^x[X烁^ô̂́ÃNXł͂ȂAʂ̃v_Ng blancoDbMetaDataS܂B
     * 
     * @param connDef
     *            f[^x[XڑB
     * @param blancoSqlDirectory
     *            o͐fBNgB
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     */
    public void process(final BlancoDbSetting dbSetting,
            final File blancoSqlDirectory) throws SQLException {
        System.out.println(BlancoDbCommonConstants.PRODUCT_NAME + " ("
                + BlancoDbCommonConstants.VERSION + ") P\ANZTSQL: Jn.");
        fDbSetting = dbSetting;
        Connection conn = null;
        try {
            conn = BlancoDbUtil.connect(dbSetting);
            BlancoDbUtil.getDatabaseVersionInfo(conn, dbSetting);

            final DatabaseMetaData metadata = conn.getMetaData();

            final List listTables = BlancoDbMetaDataTable.getTables(metadata,
                    dbSetting.getSchema(), null, new String[] { "TABLE" });

            // \ɂ܂KvŒ̃^擾܂B
            for (int indexTable = 0; indexTable < listTables.size(); indexTable++) {
                final BlancoDbMetaDataTableStructure tableStructure = (BlancoDbMetaDataTableStructure) listTables
                        .get(indexTable);

                tableStructure.setColumns(BlancoDbMetaDataTable.getColumns(
                        metadata, tableStructure.getCatalog(), dbSetting
                                .getSchema(), tableStructure.getName()));

                tableStructure
                        .setPrimaryKeys(BlancoDbMetaDataTable
                                .getPrimaryKeys(metadata, tableStructure
                                        .getCatalog(), dbSetting.getSchema(),
                                        tableStructure.getName()));

                // OL[֘Ã^ɂẮAxAbvړIƂĎ擾ȗĂ܂B
            }

            serializeTable(conn, listTables, blancoSqlDirectory
                    .getAbsolutePath());

        } finally {
            BlancoDbUtil.close(conn);
            conn = null;
            System.out.println("P\ANZTSQL: I.");
        }
    }

    /**
     * \̒PʂŎWꂽXMLt@Cɏo܂B
     * 
     * @param dbInfoCollector
     * @param listTables
     * @param outputDirectoryName
     * @throws SQLException
     */
    private void serializeTable(final Connection conn, final List listTables,
            final String outputDirectoryName) throws SQLException {

        for (int index = 0; index < listTables.size(); index++) {
            final List resultSqlInfo = new ArrayList();

            final BlancoDbMetaDataTableStructure table = (BlancoDbMetaDataTableStructure) listTables
                    .get(index);
            if (progress(index + 1, listTables.size(), table.getName()) == false) {
                break;
            }

            try {
                System.out.println("\[" + table.getName() + "]܂");
                processEveryTable(listTables, table, resultSqlInfo);
            } catch (StringIndexOutOfBoundsException ex) {
                System.out.println("\[" + table.getName()
                        + "]̏̉ߒŗO܂: " + ex.toString());
                ex.printStackTrace();

                // Oɂ́Ad̂ ̕\܂B
                conn.rollback();
                continue;
            }

            // \̒PʂSQLXMLt@Cɏo͂܂B
            BlancoDbXmlSerializer.serialize(resultSqlInfo, new File(
                    outputDirectoryName + "/SimpleTable"
                            + BlancoNameAdjuster.toClassName(table.getName())
                            + ".xml"));
        }
    }

    /**
     * ̂̂̕\o͏܂B
     * 
     * @param service
     * @param collector
     * @param metadata
     * @param document
     * @param eleRoot
     * @param table
     * @throws SQLException
     */
    private void processEveryTable(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {
        generateSelect(listTables, table, resultSqlInfo);

        // XV\J[\p\ǂ̓\bhŔf܂B
        generateSelectUpdatable(listTables, table, resultSqlInfo);

        generateSelectColumn(listTables, table, resultSqlInfo);

        // 2005.11.11 SelectAll\bh͕܂B
        generateSelectAll(listTables, table, resultSqlInfo);

        generateInsert(listTables, table, resultSqlInfo, false);
        generateInsert(listTables, table, resultSqlInfo, true);

        generateUpdate(listTables, table, resultSqlInfo);

        generateDelete(listTables, table, resultSqlInfo);
    }

    /**
     * \݂̂ɂāA܂̓NXɕϊ܂B
     * 
     * @param table
     * @return
     */
    private String getBaseClassName(final BlancoDbMetaDataTableStructure table) {
        return BlancoNameAdjuster.toClassName(table.getName());
    }

    /**
     * sANZT𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateSelect(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Select";

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.ITERATOR);
        sqlInfo.setSingle(true);
        sqlInfo.setScroll(fBundle.getSelectScroll());
        sqlInfo.setUpdatable(false);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(columnStructure.getName());
        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (BlancoDbUtil.isPrimaryKey(table, columnStructure)) {
                if (isSkipTypeForSimpleTable(columnStructure)) {
                    // P\ƂĂ̓XLbvׂ^łB
                    // oCi⃊[_̓L[ƂĂ͗pł܂B
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                } else {
                    sql.append("\n   AND ");
                }

                final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
                if (fFormatSql) {
                    wrkStructure.setName("inParam"
                            + BlancoNameAdjuster.toClassName(wrkStructure
                                    .getName()));
                } else {
                    wrkStructure.setName(BlancoNameAdjuster
                            .toParameterName(wrkStructure.getName()));
                }

                sql.append(columnStructure.getName() + " = #"
                        + wrkStructure.getName());

                sqlInfo.getInParameterList().add(wrkStructure);
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        // Ō̍ŌŃ[gm[hɒǉ܂B
        resultSqlInfo.add(sqlInfo);
    }

    /**
     * XV\Ȍ𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateSelectUpdatable(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        switch (fDbSetting.getDriverName()) {
        case BlancoDbDriverNameStringGroup.SQLSERVER_2000:
        case BlancoDbDriverNameStringGroup.SQLSERVER_2005:
        case BlancoDbDriverNameStringGroup.ORACLE:
        case BlancoDbDriverNameStringGroup.POSTGRESQL:
            // blancoDbƂčXV\ȌɑΉĂf[^x[XłB\łB
            break;
        default:
            // ł܂B
            return;
        }

        final String name = CLASS_PREFIX + getBaseClassName(table)
                + "SelectUpdatable";

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.ITERATOR);
        sqlInfo.setSingle(false);
        sqlInfo.setScroll(fBundle.getSelectUpdatableScroll());
        sqlInfo.setUpdatable(true);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            // XV\œ߂ɁAS擾Ă܂B

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(columnStructure.getName());
        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        switch (fDbSetting.getDriverName()) {
        case BlancoDbDriverNameStringGroup.SQLSERVER_2000:
        case BlancoDbDriverNameStringGroup.SQLSERVER_2005:
            sql.append(" WITH (UPDLOCK)");
            break;
        }

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (BlancoDbUtil.isPrimaryKey(table, columnStructure)) {
                if (isSkipTypeForSimpleTable(columnStructure)) {
                    // P\ƂĂ̓XLbvׂ^łB
                    // oCi͌L[ɗpł܂B
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                } else {
                    sql.append("\n   AND ");
                }

                final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
                if (fFormatSql) {
                    wrkStructure.setName("inParam"
                            + BlancoNameAdjuster.toClassName(wrkStructure
                                    .getName()));
                } else {
                    wrkStructure.setName(BlancoNameAdjuster
                            .toParameterName(wrkStructure.getName()));
                }

                sql.append(columnStructure.getName() + " = #"
                        + wrkStructure.getName());

                sqlInfo.getInParameterList().add(wrkStructure);
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        switch (fDbSetting.getDriverName()) {
        case BlancoDbDriverNameStringGroup.ORACLE:
        case BlancoDbDriverNameStringGroup.POSTGRESQL:
            sql.append(" FOR UPDATE");
            break;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        // Ō̍ŌŃ[gm[hɒǉ܂B
        resultSqlInfo.add(sqlInfo);
    }

    /**
     * InputStreamReaderɃ}bv^ɂāAʂIterator𐶐܂B
     * 
     * IteratorȊOł InputStreamReaderɃ}bv^͍ڂƂĂ͐XLbv܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateSelectColumn(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);

            if (isSkipTypeForSimpleTable(columnStructure) == false) {
                // ł̓oCiу[_û݁v܂B
                // ̉ӏƔ]Ă_ɒڂĂB
                continue;
            }

            final String name = CLASS_PREFIX + getBaseClassName(table)
                    + "Column"
                    + BlancoNameAdjuster.toClassName(columnStructure.getName());

            final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
            sqlInfo.setName(name);
            sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.ITERATOR);

            // BINARYASCIISTREAM̗ւ̃ANZTPstŏo͂邩ǂB
            // SQL Server 2000ɂẮAPstŐsƁAPsgetSingleRow\bh
            // next() { next() 2xĂяos_ŁAxڂ̌ʂ
            // Xg[Ă܂ƂmĂ܂B
            // ̂悤ȔwiAftHg false ł PsƂłB
            sqlInfo.setSingle(fBundle.getSimpleColBinaryAsciiSelectSinglerow()
                    .equals("true"));
            sqlInfo.setScroll(fBundle.getSelectScroll());
            sqlInfo.setUpdatable(false);

            final StringBuffer sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append(columnStructure.getName());
            sql.append("\n FROM " + escapeSqlName(table.getName()));

            boolean isFirstPrimaryKey = true;
            for (int indexPrimaryKey = 0; indexPrimaryKey < table.getColumns()
                    .size(); indexPrimaryKey++) {
                final BlancoDbMetaDataColumnStructure columnPrimaryKey = (BlancoDbMetaDataColumnStructure) table
                        .getColumns().get(indexPrimaryKey);

                if (isSkipTypeForSimpleTable(columnPrimaryKey)) {
                    // ƂĂ̓XLbvׂ^łB
                    continue;
                }

                if (BlancoDbUtil.isPrimaryKey(table, columnPrimaryKey) == false) {
                    continue;
                }

                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n WHERE ");
                } else {
                    sql.append("\n   AND ");
                }

                final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnPrimaryKey);
                if (fFormatSql) {
                    wrkStructure.setName("inParam"
                            + BlancoNameAdjuster.toClassName(wrkStructure
                                    .getName()));
                } else {
                    wrkStructure.setName(BlancoNameAdjuster
                            .toParameterName(wrkStructure.getName()));
                }

                sql.append(columnPrimaryKey.getName() + " = #"
                        + wrkStructure.getName());

                sqlInfo.getInParameterList().add(wrkStructure);
            }

            if (isFirstPrimaryKey) {
                // vC}[L[ꌏĂȂۂɂ́A
                // WHERE쐬Ă܂B
                // s͊댯ƔfAf܂B
                return;
            }

            sqlInfo.setQuery(sql.toString());
            if (fFormatSql) {
                try {
                    sqlInfo.setQuery(getSqlFormatter().format(
                            sqlInfo.getQuery()));
                } catch (BlancoSqlFormatterException e) {
                    // Ȃ̂ŁÂ܂ܐi݂܂B
                    e.printStackTrace();
                }
            }

            // Ō̍ŌŃ[gm[hɒǉ܂B
            resultSqlInfo.add(sqlInfo);
        }
    }

    /**
     * SڂIterator𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateSelectAll(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table)
                + "SelectAll";

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.ITERATOR);
        sqlInfo.setSingle(false);
        sqlInfo.setScroll(fBundle.getSelectAllScroll());
        sqlInfo.setUpdatable(false);

        final StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(columnStructure.getName());

        }

        if (isFirstColumn) {
            // ЂƂ񂪏܂łBf܂B
            return;
        }

        sql.append("\n  FROM " + escapeSqlName(table.getName()));

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (BlancoDbUtil.isPrimaryKey(table, columnStructure)) {
                if (isFirstPrimaryKey) {
                    isFirstPrimaryKey = false;
                    sql.append("\n ORDER BY ");
                } else {
                    sql.append(", ");
                }
                sql.append(columnStructure.getName());
            }
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        // Ō̍ŌŃ[gm[hɒǉ܂B
        resultSqlInfo.add(sqlInfo);
    }

    /**
     * }sInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @param isIgnoreNullable
     * @throws SQLException
     */
    private void generateInsert(final List listTables,
            final BlancoDbMetaDataTableStructure table,
            final List resultSqlInfo, final boolean isIgnoreNullable)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Insert"
                + (isIgnoreNullable ? "NoNulls" : "");

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.INVOKER);
        sqlInfo.setSingle(true);

        final StringBuffer sql = new StringBuffer();
        sql.append("INSERT");
        sql.append("\n  INTO " + escapeSqlName(table.getName()));
        sql.append("\n       (");

        boolean isNullableColumnExist = false;
        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (isIgnoreNullable
                    && columnStructure.getNullable() == ResultSetMetaData.columnNullable) {
                isNullableColumnExist = true;
                continue;
            }

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }
            sql.append(columnStructure.getName());
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        sql.append(")");
        sql.append("\nVALUES");
        sql.append("\n       (");

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (isIgnoreNullable
                    && columnStructure.getNullable() == ResultSetMetaData.columnNullable) {
                continue;
            }

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstPrimaryKey) {
                isFirstPrimaryKey = false;
            } else {
                sql.append(", ");
            }

            final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
            if (fFormatSql) {
                wrkStructure.setName("inParam"
                        + BlancoNameAdjuster
                                .toClassName(wrkStructure.getName()));
            } else {
                wrkStructure.setName(BlancoNameAdjuster
                        .toParameterName(wrkStructure.getName()));
            }

            sql.append("#" + wrkStructure.getName());

            sqlInfo.getInParameterList().add(wrkStructure);
        }
        sql.append(")");

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        if (isIgnoreNullable == false || isNullableColumnExist) {
            // NULLe񂪏ꂽꍇɂ̂XMLɒǉ܂B
            resultSqlInfo.add(sqlInfo);
        }
    }

    /**
     * XVsInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateUpdate(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Update";

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.INVOKER);
        sqlInfo.setSingle(true);

        final StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + escapeSqlName(table.getName()));
        sql.append("\n   SET ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (BlancoDbUtil.isPrimaryKey(table, columnStructure)) {
                continue;
            }

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append(", ");
            }

            final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
            if (fFormatSql) {
                wrkStructure.setName("inParam"
                        + BlancoNameAdjuster
                                .toClassName(wrkStructure.getName()));
            } else {
                wrkStructure.setName(BlancoNameAdjuster
                        .toParameterName(wrkStructure.getName()));
            }

            sql.append(columnStructure.getName() + " = #"
                    + wrkStructure.getName());

            sqlInfo.getInParameterList().add(wrkStructure);
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        sql.append("\n WHERE ");

        boolean isFirstPrimaryKey = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (BlancoDbUtil.isPrimaryKey(table, columnStructure) == false) {
                continue;
            }

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstPrimaryKey) {
                isFirstPrimaryKey = false;
            } else {
                sql.append("\n   AND ");
            }

            final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
            wrkStructure.setName("where"
                    + BlancoNameAdjuster.toClassName(wrkStructure.getName()));

            sql.append(columnStructure.getName() + " = #"
                    + wrkStructure.getName());

            sqlInfo.getInParameterList().add(wrkStructure);
        }

        if (isFirstPrimaryKey) {
            // vC}[L[ꌏĂȂۂɂ́A
            // WHERE쐬Ă܂B
            // s͊댯ƔfAf܂B
            return;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        // Ō̍ŌŃ[gm[hɒǉ܂B
        resultSqlInfo.add(sqlInfo);
    }

    /**
     * 폜sInvoker𐶐܂B
     * 
     * @param collector
     * @param metadata
     * @param table
     * @param document
     * @param eleRoot
     * @throws SQLException
     */
    private void generateDelete(final List listTables,
            final BlancoDbMetaDataTableStructure table, final List resultSqlInfo)
            throws SQLException {

        final String name = CLASS_PREFIX + getBaseClassName(table) + "Delete";

        final BlancoDbSqlInfoStructure sqlInfo = new BlancoDbSqlInfoStructure();
        sqlInfo.setName(name);
        sqlInfo.setType(BlancoDbSqlInfoTypeStringGroup.INVOKER);
        sqlInfo.setSingle(true);

        final StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM " + escapeSqlName(table.getName()));
        sql.append("\n WHERE ");

        boolean isFirstColumn = true;
        for (int indexCol = 0; indexCol < table.getColumns().size(); indexCol++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) table
                    .getColumns().get(indexCol);
            if (BlancoDbUtil.isPrimaryKey(table, columnStructure) == false) {
                continue;
            }

            if (isSkipTypeForSimpleTable(columnStructure)) {
                // P\ƂĂ̓XLbvׂ^łB
                continue;
            }

            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                sql.append("\n   AND ");
            }

            final BlancoDbMetaDataColumnStructure wrkStructure = cloneColumnStructure(columnStructure);
            if (fFormatSql) {
                wrkStructure.setName("inParam"
                        + BlancoNameAdjuster
                                .toClassName(wrkStructure.getName()));
            } else {
                wrkStructure.setName(BlancoNameAdjuster
                        .toParameterName(wrkStructure.getName()));
            }

            sql.append(columnStructure.getName() + " = #"
                    + wrkStructure.getName());

            sqlInfo.getInParameterList().add(wrkStructure);
        }

        if (isFirstColumn) {
            // ЂƂ񂪏Ă܂B
            // ̑gݍ킹͐XLbv܂B
            return;
        }

        sqlInfo.setQuery(sql.toString());
        if (fFormatSql) {
            try {
                sqlInfo.setQuery(getSqlFormatter().format(sqlInfo.getQuery()));
            } catch (BlancoSqlFormatterException e) {
                // Ȃ̂ŁÂ܂ܐi݂܂B
                e.printStackTrace();
            }
        }

        // Ō̍ŌŃ[gm[hɒǉ܂B
        resultSqlInfo.add(sqlInfo);
    }

    /**
     * ^ꂽSQL̖(\܂͗)ɃGXP[vׂ(Xy[X)܂܂ĂꍇɁA\̂̂_uNI[gŃGXP[v܂B
     * 
     * @param tableName
     * @return
     */
    public String escapeSqlName(final String tableName) {
        if (tableName.indexOf(" ") >= 0) {
            return "\"" + tableName + "\"";
        }
        return tableName;
    }

    private static BlancoDbMetaDataColumnStructure cloneColumnStructure(
            final BlancoDbMetaDataColumnStructure argColumnStructure) {
        final BlancoDbMetaDataColumnStructure columnStructureWrk = new BlancoDbMetaDataColumnStructure();
        columnStructureWrk.setName(argColumnStructure.getName());
        columnStructureWrk.setDataType(argColumnStructure.getDataType());
        columnStructureWrk.setNullable(argColumnStructure.getNullable());
        return columnStructureWrk;
    }

    /**
     * SQL`tH[}b^擾܂B
     * 
     * @return SQL`tH[}b^B
     */
    private static BlancoSqlFormatter getSqlFormatter() {
        return new BlancoSqlFormatter(new BlancoSqlRule());
    }

    /**
     * P\̏ƂăXLbvׂ^ł邩ǂ肵܂B
     * 
     * ̃\bh́A[Vif[^x[XA邢̓f[^x[XAPIɂςƂȂӏłB
     * 
     * TODO JavaȊOɂẴNX𗘗pۂɂ́Ã\bhI[o[ChKv܂B
     * 
     * @param argTypeName
     *            ^BpbP[WB
     * @return XLbvׂ^̏ꍇɂtrueB
     */
    protected boolean isSkipTypeForSimpleTable(
            final BlancoDbMetaDataColumnStructure columnStructure) {
        switch (columnStructure.getDataType()) {
        case Types.BINARY:
        case Types.VARBINARY:
        case Types.LONGVARBINARY:
        case Types.BLOB:
            return true;
        case Types.LONGVARCHAR:
        case Types.CLOB:
            return true;
        case Types.JAVA_OBJECT:
        case Types.DISTINCT:
        case Types.STRUCT:
        case Types.ARRAY:
        case Types.NULL:
        case Types.OTHER:
        case Types.REF:
        case Types.DATALINK:
            return true;
        default:
            return false;
        }
    }
}