/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractClass;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.GetStatementMethod;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.expander.query.iterator.SetInputParameterMethod;
import blanco.db.resourcebundle.BlancoDbResourceBundle;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃NXWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class QueryCallerClass extends BlancoDbAbstractClass {
    private final BlancoDbResourceBundle fBundle = new BlancoDbResourceBundle();

    public QueryCallerClass(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory) {
        super(argDbSetting, argSqlInfo, argCgFactory);
    }

    public BlancoCgSourceFile expand() {
        final String className = BlancoNameAdjuster.toClassName(fSqlInfo
                .getName())
                + "Caller";

        fCgSourceFile = fCgFactory.createSourceFile(fDbSetting.getBasePackage()
                + ".query", "This code is generated by blanco Framework.");
        fCgClass = fCgFactory.createClass(className, className
                + "NX (QueryCaller)B");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getLangDoc().getDescriptionList().add(
                "ďo^SQLbsOĊeANZT񋟂܂B<br>");

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".exception.IntegrityConstraintException");

        // BlancoDbUtil͏ɃC|[g܂B
        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".util.BlancoDbUtil");

        new ConnectionField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();
        new StatementField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass, true).expand();

        if (fDbSetting.getLogging()) {
            fCgSourceFile.getImportList().add(
                    "org.apache.commons.logging.LogFactory");
            new LogField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        new QueryConstructor(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new GetQueryMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new PrepareCallMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();
        new PrepareCallMethod2(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new SetInputParameterMethod(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass, true).expand();

        new ExecuteMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        for (int index = 0; index < fSqlInfo.getOutParameterList().size(); index++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                    .getOutParameterList().get(index);
            new GetCallerOutputParameterMethod(fDbSetting, fSqlInfo,
                    fCgFactory, fCgSourceFile, fCgClass, columnStructure)
                    .expand();
        }

        if (fBundle.getExpanderDisableGetStatement().equals("true") == false) {
            // 1.6.8ȑOƌ݊Kvꍇɂ̂ getStatement𐶐܂B
            new GetStatementMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass, true).expand();
        }

        new CloseMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new Finalize(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile, fCgClass)
                .expand();

        return fCgSourceFile;
    }
}