package blanco.doclisting;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoXmlUtil;

/**
 * blancoDocListing狤ʓIɗp郆[eBeBNXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoDocListingUtil {
    /**
     * ^ꂽXMLt@Cp[XDocumentElement擾܂B
     * 
     * @param fileRead
     *            XMLƂēǂݍޓ̓t@C
     * @return ǂݍ񂾌ʁA쐬ꂽGg
     */
    public static Element parseXmlDocument(final File fileRead) {
        if (fileRead.exists() == false) {
            throw new IllegalArgumentException("̓t@C["
                    + fileRead.getAbsolutePath() + "]܂Bf܂B");
        }
        final DocumentBuilderFactory documentFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException("OBf܂B:" + ex.toString());
        }
        try {
            document = documentBuilder.parse(fileRead);
        } catch (SAXException ex) {
            throw new IllegalArgumentException("OBf܂B:" + ex.toString());
        } catch (IOException ex) {
            throw new IllegalArgumentException("OBf܂B:" + ex.toString());
        }
        return document.getDocumentElement();
    }

    /**
     * ^ꂽm[hRs[܂B
     * 
     * @param nodeSource
     *            Rs[m[hBnull^ꂽꍇɂ͏SsȂ܂ܐ߂܂B
     * @param documentTarget
     *            ^[QbgDocumentB
     * @param elementTarget
     *            ^[QbgElementB
     */
    public static void copyNode(final Node nodeSource,
            final Document documentTarget, final Element elementTarget) {
        if (nodeSource == null) {
            // \[Xnull̏ꍇɂ͏s܂B
            return;
        }
        if (documentTarget == null) {
            // ^[Qbgnull̏ꍇɂ͏s܂B
            return;
        }
        if (elementTarget == null) {
            // ^[Qbgnull̏ꍇɂ͏s܂B
            return;
        }

        final NodeList nodeList = nodeSource.getChildNodes();
        if (nodeList == null) {
            return;
        }

        final int nodeListSize = nodeList.getLength();
        for (int index = 0; index < nodeListSize; index++) {
            final Node nodeLook = nodeList.item(index);
            if (nodeLook instanceof Element) {
                final Element elementNew = documentTarget
                        .createElement(nodeLook.getNodeName());
                elementTarget.appendChild(elementNew);
                copyNode(nodeLook, documentTarget, elementNew);
            } else if (nodeLook instanceof Text) {
                final Text textCopy = documentTarget
                        .createTextNode(((Text) nodeLook).getData());
                elementTarget.appendChild(textCopy);
            } else {
                System.out.println("m[h:[" + nodeList.toString() + "]");
            }
        }
    }

    /**
     * ^ꂽXgL[ƂɃ\[g܂B
     * 
     * @param argKeyElementName
     *            \[g̃L[B
     * @param argListCommon
     *            \[gXgB
     */
    public static void sortListByKey(final String argKeyElementName,
            final List argListCommon) {
        // \[g̏KvłB
        Collections.sort(argListCommon, new Comparator() {
            public int compare(final Object arg1, final Object arg2) {
                final Element val1 = (Element) arg1;
                final Element val2 = (Element) arg2;
                final String strVal1 = BlancoXmlUtil.getTextContent(val1,
                        argKeyElementName);
                final String strVal2 = BlancoXmlUtil.getTextContent(val2,
                        argKeyElementName);
                if (strVal1 == null) {
                    return -1;
                }
                if (strVal2 == null) {
                    return 1;
                }
                return (strVal1.compareTo(strVal2));
            }
        });
    }
}
