/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dbdoclisting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlTokenConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import blanco.db.common.IBlancoDbProgress;
import blanco.db.common.stringgroup.BlancoDbSqlInfoScrollStringGroup;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.util.BlancoDbXmlParser;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.dbdoclisting.csv.io.BlancoCsvIOException;
import blanco.dbdoclisting.csv.io.BlancoDbDocListingCsvCsvWriter;
import blanco.dbdoclisting.csv.record.BlancoDbDocListingCsvCsvRecord;

/**
 * XMLt@CCSV`ɂSQL`ꗗt@C𐶐܂B
 */
public abstract class BlancoDbDocListingXml2Csv implements IBlancoDbProgress {
    private String fTargetDir;

    private String fTargetFile;

    /**
     * XMLt@CCSV`ɂSQL`ꗗt@C𐶐܂B
     * 
     * @param targetDir
     * @param targetFile
     * @param blancoSqlDirectory
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    public void process(final String targetDir, final String targetFile,
            final File blancoSqlDirectory) throws SQLException, SAXException,
            IOException, ParserConfigurationException, ClassNotFoundException,
            TransformerException {
        System.out.println(BlancoDbDocListingConstants.PRODUCT_NAME + " ("
                + BlancoDbDocListingConstants.VERSION + ") hLgꗗ: Jn.");

        fTargetDir = targetDir;
        fTargetFile = targetFile;

        final ArrayList listResult = new ArrayList();

        final File[] fileSettingXml = blancoSqlDirectory.listFiles();
        for (int index = 0; index < fileSettingXml.length; index++) {
            if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                // t@C̊gq xml ł̂̂ݏ܂B
                continue;
            }

            final List listSql = new BlancoDbXmlParser()
                    .parse(fileSettingXml[index]);
            listResult.addAll(listSql);
        }

        writeCsv(listResult);
    }

    /**
     * SQL`ꗗ CSVt@CւƏo͂܂B
     * 
     * @param listResult
     */
    private void writeCsv(final ArrayList listResult) {
        BlancoDbDocListingCsvCsvWriter writer = null;
        BlancoDbSqlInfoStructure sqlInfoCurrent = null;

        try {
            new File(fTargetDir).mkdirs();

            writer = new BlancoDbDocListingCsvCsvWriter(new BufferedWriter(
                    new OutputStreamWriter(new FileOutputStream(fTargetDir
                            + "/" + fTargetFile + ".csv"))));

            writer.writeTitle();

            for (int index = 0; index < listResult.size(); index++) {
                final BlancoDbSqlInfoStructure sqlInfo = (BlancoDbSqlInfoStructure) listResult
                        .get(index);
                sqlInfoCurrent = sqlInfo;

                final BlancoDbDocListingCsvCsvRecord record = new BlancoDbDocListingCsvCsvRecord();
                record.setName(sqlInfo.getName());
                record.setType(getTypeName(sqlInfo));
                record.setDescription(sqlInfo.getDescription());
                record.setSqlHead(getSqlHead(sqlInfo.getQuery()));
                record.setTables(getTableNames(sqlInfo.getQuery()));

                if (sqlInfo.getSingle()) {
                    record.setSingle("");
                }

                if (sqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.ITERATOR) {
                    record.setScroll(new BlancoDbSqlInfoScrollStringGroup()
                            .convertToString(sqlInfo.getScroll()));
                }

                if (sqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.ITERATOR
                        && sqlInfo.getUpdatable()) {
                    record.setUpdatable("");
                }

                writer.writeRecord(record);
            }
        } catch (IOException ex) {
            System.out.println("SQL`[" + sqlInfoCurrent.getName()
                    + "]ɗO܂:" + ex.toString());
            ex.printStackTrace();
        } catch (BlancoCsvIOException ex) {
            System.out.println("SQL`[" + sqlInfoCurrent.getName()
                    + "]ɗO܂:" + ex.toString());
            ex.printStackTrace();
        } catch (StringIndexOutOfBoundsException ex) {
            System.out.println("SQL`[" + sqlInfoCurrent.getName()
                    + "]ɗO܂:" + ex.toString());
            throw ex;
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * SQL͂ėpĂ\̈ꗗ擾܂B
     * 
     * @param argSql
     * @return
     */
    private String getTableNames(final String argSql) {
        final HashMap mapTableNames = new HashMap();
        boolean startTableName = false;

        final BlancoSqlParser parser = new BlancoSqlParser();
        final ArrayList list = parser.parse(argSql);
        for (int index = 0; index < list.size(); index++) {
            final BlancoSqlToken token = (BlancoSqlToken) list.get(index);
            switch (token.getType()) {
            case BlancoSqlTokenConstants.KEYWORD:
                if (token.getString().toUpperCase().equals("FROM")) {
                    // SELECT  DELETE  FROM
                    startTableName = true;
                } else if (token.getString().toUpperCase().equals("UPDATE")) {
                    // UPDATE \  UPDATE
                    startTableName = true;
                } else if (token.getString().toUpperCase().equals("DELETE")) {
                    // DELETE Ȃ \  DELETE (ȂƏȗ\Ƃ̂)
                    startTableName = true;
                } else if (token.getString().toUpperCase().equals("INTO")) {
                    // INSERT INTO  INTO
                    startTableName = true;
                } else if (token.getString().toUpperCase().equals("JOIN")) {
                    // LEFT OUTER JOINȂǂ JOIN
                    startTableName = true;
                } else {
                    startTableName = false;
                }
                break;
            case BlancoSqlTokenConstants.NAME:
                if (startTableName) {
                    // ͕\łB
                    if (mapTableNames.get(token.getString()) == null) {
                        // ꍇɂ̂ݓo^܂B
                        mapTableNames.put(token.getString(), token.getString());
                    }
                }
                break;
            }
        }

        String result = "";
        final Iterator iterator = mapTableNames.entrySet().iterator();
        for (; iterator.hasNext();) {
            final Entry entry = (Entry) iterator.next();
            if (result.length() > 0) {
                result += "\n";
            }
            result += entry.getKey();
        }

        return result;
    }

    /**
     * SQL`^Cv\p̃^Cv̂擾܂B
     * 
     * @param argSqlInfo
     * @return
     */
    private String getTypeName(final BlancoDbSqlInfoStructure argSqlInfo) {
        switch (argSqlInfo.getType()) {
        case BlancoDbSqlInfoTypeStringGroup.ITERATOR:
            return "^";
        case BlancoDbSqlInfoTypeStringGroup.INVOKER:
            return "XV^";
        case BlancoDbSqlInfoTypeStringGroup.CALLER:
            return "ďo^";
        default:
            return "(s)";
        }
    }

    /**
     * SQL̐擪擾܂B
     * 
     * @param argSql
     * @return
     */
    private String getSqlHead(final String argSql) {

        final BlancoSqlParser parser = new BlancoSqlParser();
        final ArrayList list = parser.parse(argSql);
        for (int index = 0; index < list.size(); index++) {
            final BlancoSqlToken token = (BlancoSqlToken) list.get(index);
            switch (token.getType()) {
            case BlancoSqlTokenConstants.KEYWORD:
                return token.getString();
            }
        }

        return "(擾s)";
    }
}
