/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dbdoclisting.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.db.common.BlancoDbMeta2Xml;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.dbdoclisting.BlancoDbDocListingConstants;
import blanco.dbdoclisting.BlancoDbDocListingXml2Csv;
import blanco.dbdoclisting.resourcebundle.BlancoDbDocListingResourceBundle;

/**
 * XMLt@CCSV`ɂSQL`ꗗt@C𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoDbDocListingTask extends AbstractBlancoDbDocListingTask {
    /**
     * \[XohANZTIuWFNgL܂B
     */
    private final BlancoDbDocListingResourceBundle fBundle = new BlancoDbDocListingResourceBundle();

    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoDbDocListingConstants.PRODUCT_NAME
                + " (" + BlancoDbDocListingConstants.VERSION + ")");

        try {
            System.out.println("dbdoclisting: begin.");
            final long startMills = System.currentTimeMillis();

            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + BlancoDbDocListingConstants.TARGET_SUBDIRECTORY + "/sql");
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbSetting dbSetting = new BlancoDbSetting();
            dbSetting.setTargetDir(getTargetdir());

            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            final BlancoDbMeta2Xml meta2Xml = new BlancoDbMeta2Xml();
            meta2Xml.setCacheMeta2Xml(getCache().equals("true"));
            meta2Xml.processDirectory(fileMetadir, blancoTmpDbSqlDirectory
                    .getAbsolutePath());

            final BlancoDbDocListingXml2Csv generator = new BlancoDbDocListingXml2Csv() {
                public boolean progress(int progressCurrent, int progressTotal,
                        String progressItem) {
                    // trueԂ܂B
                    return true;
                }
            };
            generator.process(getTargetdir(), getTargetname(),
                    blancoTmpDbSqlDirectory);

            final long endMills = System.currentTimeMillis() - startMills;
            System.out.println("dbdoclisting: end: " + (endMills / 1000)
                    + " sec.");
        } catch (SQLException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr006()
                    + e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("͒lG[:" + e.toString());
        }
    }
}
