/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jni;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import blanco.bcel.util.BlancoBcelXmlUnmarshaller;
import blanco.bcel.valueobject.BlancoBcelClassStructure;
import blanco.bcel.valueobject.BlancoBcelMethodStructure;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * XMLt@C JNIďopC++\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoJniXml2Cpp {
    /**
     * XMLt@C JNIďopC++\[XR[h܂B
     * 
     * @param inputFile
     *            XMLԌ`t@CB
     * @param outTargetDirectory
     *            C++\[Xt@CB
     * @throws IOException
     *             o͗OꍇB
     */
    public final void process(final File inputFile,
            final File outTargetDirectory) throws IOException {
        final BlancoBcelXmlUnmarshaller unmarshaller = new BlancoBcelXmlUnmarshaller();
        final BlancoBcelClassStructure classStructure = unmarshaller
                .unmarshal(inputFile);

        final String classNameWithoutPackage = BlancoNameUtil
                .trimJavaPackage(classStructure.getName());
        final String classFileName = BlancoStringUtil.replaceAll(classStructure
                .getName(), "/", "_");

        final BufferedWriter writerH = new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(outTargetDirectory
                        .getAbsolutePath()
                        + "/" + classFileName + ".h")));
        final BufferedWriter writerCpp = new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(outTargetDirectory
                        .getAbsolutePath()
                        + "/" + classFileName + ".cpp")));
        try {
            // H
            writerH.write("#pragma once");
            writerH.newLine();
            writerH.write("");
            writerH.newLine();
            writerH.write("#include <windows.h> // for WideCharToMultiByte");
            writerH.newLine();
            writerH.write("#include <stdio.h>");
            writerH.newLine();
            writerH.write("#include <stdlib.h>");
            writerH.newLine();
            writerH.write("#include \"jni.h\"");
            writerH.newLine();
            writerH.write("");
            writerH.newLine();

            // CPP
            writerCpp.write("#include \"" + classFileName + ".h\"");
            writerCpp.newLine();

            writerCpp.newLine();

            // NX錾
            writerH.write("class " + classNameWithoutPackage);
            writerH.newLine();
            writerH.write("{");
            writerH.newLine();
            writerH.write("private:");
            writerH.newLine();
            writerH.write("\tJNIEnv *env;");
            writerH.newLine();
            writerH.write("\tJavaVM *jvm;");
            writerH.newLine();
            writerH.write("\tjclass myClass;");
            writerH.newLine();
            writerH.write("\tjobject myObject;");
            writerH.newLine();
            writerH.newLine();
            writerH.write("public:");
            writerH.newLine();

            // RXgN^ ʂ̃\bĥƂŐB

            // ʊ֐ŋo
            writerCpp.write("char* java2Cpp(JNIEnv *env, jstring s)");
            writerCpp.newLine();
            writerCpp.write("{");
            writerCpp.newLine();
            writerCpp.write("\tjsize vLen = env->GetStringLength(s);");
            writerCpp.newLine();
            writerCpp.write("\tchar* d = (char*) malloc(vLen * 4);");
            writerCpp.newLine();
            writerCpp
                    .write("\tconst jchar* vStr = env->GetStringChars(s, NULL);");
            writerCpp.newLine();
            writerCpp
                    .write("\tint eLen = WideCharToMultiByte(CP_ACP, 0,(LPCWSTR)vStr, vLen, d, vLen * 4, NULL, NULL);");
            writerCpp.newLine();
            writerCpp.write("\td[eLen] = 0;");
            writerCpp.newLine();
            writerCpp.write("\tenv->ReleaseStringChars(s, vStr);");
            writerCpp.newLine();
            writerCpp.write("\treturn d;");
            writerCpp.newLine();
            writerCpp.write("}");
            writerCpp.newLine();
            writerCpp.newLine();
            writerCpp.write("jstring cpp2Java(JNIEnv *env, char* s)");
            writerCpp.newLine();
            writerCpp.write("{");
            writerCpp.newLine();
            writerCpp.write("\tchar uBuf[10240];");
            writerCpp.newLine();
            writerCpp.write("\tint dLen = 0;");
            writerCpp.newLine();
            writerCpp.write("\tif(s != NULL) {");
            writerCpp.newLine();
            writerCpp
                    .write("\t\tdLen = MultiByteToWideChar(CP_ACP, 0, s, -1, (LPWSTR)uBuf, sizeof(uBuf));");
            writerCpp.newLine();
            writerCpp.write("\t\tdLen--;");
            writerCpp.newLine();
            writerCpp.write("\t}");
            writerCpp.newLine();
            writerCpp
                    .write("\tjstring uStr = env->NewString((jchar *)uBuf, dLen);");
            writerCpp.newLine();
            writerCpp.write("\treturn uStr;");
            writerCpp.newLine();
            writerCpp.write("}");
            writerCpp.newLine();
            writerCpp.newLine();

            // fXgN^
            writerH.write("\t~" + classNameWithoutPackage + "(void);");
            writerH.newLine();

            writerCpp.write(classNameWithoutPackage + "::~"
                    + classNameWithoutPackage + "(void)");
            writerCpp.newLine();
            writerCpp.write("{");
            writerCpp.newLine();
            writerCpp.write("}");
            writerCpp.newLine();
            writerCpp.newLine();

            // \bh̓WJB
            for (int indexMethod = 0; indexMethod < classStructure
                    .getMethodList().size(); indexMethod++) {
                final BlancoBcelMethodStructure methodStructure = (BlancoBcelMethodStructure) classStructure
                        .getMethodList().get(indexMethod);

                if (methodStructure.getAccess().equals("public") == false) {
                    // publiĉݐ܂B
                    continue;
                }

                final boolean isConstructor = methodStructure.getName().equals(
                        "<init>");

                writerCpp.write("/*");
                writerCpp.newLine();
                writerCpp.write(" * \bh: " + methodStructure.getName());
                writerCpp.newLine();
                writerCpp.write(" *");
                writerCpp.newLine();
                for (int indexArg = 0; indexArg < methodStructure
                        .getArgumentList().size(); indexArg++) {
                    final String arg = (String) methodStructure
                            .getArgumentList().get(indexArg);

                    writerCpp.write(" * @param p[^" + indexArg + " ");
                    writerCpp.write(convertJniArgToCppArg(arg));
                    if (convertJniArgToCppArg(arg).equals("jobject")) {
                        writerCpp.write(" ");
                        writerCpp.write("IWi^[" + arg + "]");
                    }
                    writerCpp.newLine();
                }
                if (methodStructure.getReturn().equals("V") || isConstructor) {
                    // void
                } else {
                    writerCpp.write(" * @return ");
                    writerCpp.write(convertJniArgToCppArg(methodStructure
                            .getReturn()));
                    if (convertJniArgToCppArg(methodStructure.getReturn())
                            .equals("jobject")) {
                        writerCpp.write(" ");
                        writerCpp.write("IWi^[" + methodStructure.getReturn()
                                + "]");
                    }
                    writerCpp.newLine();
                }
                writerCpp.write(" */");

                // p[^WJ
                String parameterForCppArgs = "";
                String parameterForJniGetMethodIDString = "";
                {
                    parameterForJniGetMethodIDString = "(";

                    // RXgN^̏ꍇɂ͈ǉB
                    if (isConstructor) {
                        parameterForCppArgs += "JNIEnv *e, JavaVM *j";
                    }

                    for (int indexArg = 0; indexArg < methodStructure
                            .getArgumentList().size(); indexArg++) {
                        final String arg = (String) methodStructure
                                .getArgumentList().get(indexArg);
                        parameterForJniGetMethodIDString += arg;

                        if (indexArg > 0 || isConstructor) {
                            parameterForCppArgs += ", ";
                        }

                        parameterForCppArgs += convertJniArgToCppArg(arg);

                        parameterForCppArgs += " arg" + indexArg;
                    }
                    parameterForJniGetMethodIDString += ")"
                            + methodStructure.getReturn();
                }

                if (isConstructor) {
                    writerH.write("\t" + classNameWithoutPackage + "("
                            + parameterForCppArgs + ");");
                } else {
                    writerH.write("\t"
                            + (methodStructure.getReturn().equals("V") ? "void"
                                    : convertJniArgToCppArg(methodStructure
                                            .getReturn())) + " "
                            + getSafeMethodName(methodStructure.getName())
                            + "(" + parameterForCppArgs + ");");
                }
                writerH.newLine();
                writerCpp.newLine();

                if (isConstructor) {
                    writerCpp.write(classNameWithoutPackage + "::"
                            + classNameWithoutPackage + "("
                            + parameterForCppArgs + ")");
                } else {
                    writerCpp
                            .write((methodStructure.getReturn().equals("V") ? "void"
                                    : convertJniArgToCppArg(methodStructure
                                            .getReturn()))
                                    + " "
                                    + classNameWithoutPackage
                                    + "::"
                                    + getSafeMethodName(methodStructure
                                            .getName())
                                    + "("
                                    + parameterForCppArgs + ")");
                }
                writerCpp.newLine();
                writerCpp.write("{");
                writerCpp.newLine();

                // \bh̖{̂WJB
                writerCpp.write("\t// jthrowable jEx;");
                writerCpp.newLine();

                if (methodStructure.getName().equals("<init>")) {
                    writerCpp.newLine();
                    writerCpp.write("\tenv = e;");
                    writerCpp.newLine();
                    writerCpp.write("\tjvm = j;");
                    writerCpp.newLine();
                    writerCpp.write("\tmyClass = env->FindClass(\""
                            + BlancoStringUtil.replaceAll(classStructure
                                    .getName(), ".", "/") + "\");");
                    writerCpp.newLine();

                    writeCheckException(writerCpp);

                    writerCpp.newLine();
                }

                writerCpp.write("\t// \bhID̎擾");
                writerCpp.newLine();

                writerCpp.write("\tjmethodID mid = env->Get"
                        + (methodStructure.getStatic() ? "Static" : "")
                        + "MethodID(myClass, \"" + methodStructure.getName()
                        + "\", \"" + parameterForJniGetMethodIDString + "\");");
                writerCpp.newLine();

                // writeCheckException(writerCpp);
                // writerCpp.newLine();

                {
                    for (int indexArg = 0; indexArg < methodStructure
                            .getArgumentList().size(); indexArg++) {
                        final String arg = (String) methodStructure
                                .getArgumentList().get(indexArg);

                        if (arg.equals("Ljava/lang/String;")) {
                            // Strinĝݕϊʉ߂܂B
                            writerCpp.write("\t// C++񂩂JavaɕϊB");
                            writerCpp.newLine();
                            writerCpp.write("\tjstring jstr" + indexArg
                                    + " = cpp2Java(env, arg" + indexArg + ");");
                            writerCpp.newLine();
                        }
                    }
                }

                String parameterForJniNewObject = "";
                {
                    for (int indexArg = 0; indexArg < methodStructure
                            .getArgumentList().size(); indexArg++) {
                        final String arg = (String) methodStructure
                                .getArgumentList().get(indexArg);

                        if (arg.equals("Ljava/lang/String;")) {
                            parameterForJniNewObject += ", jstr" + indexArg;
                        } else {
                            parameterForJniNewObject += ", arg" + indexArg;
                        }
                    }
                }

                writerCpp.newLine();

                if (isConstructor) {
                    writerCpp.write("\t// g̍쐬B");
                    writerCpp.newLine();
                    writerCpp
                            .write("\tjobject obj = env->NewObject(myClass, mid"
                                    + parameterForJniNewObject + ");");
                    writerCpp.newLine();

                    writeCheckException(writerCpp);

                    writerCpp.write("\tmyObject = obj;");
                    writerCpp.newLine();
                } else {
                    if (methodStructure.getReturn().equals("V")) {
                        // ߂l͕Kv܂B
                        writerCpp.write("\t");
                    } else {
                        if (methodStructure.getReturn().equals(
                                "Ljava/lang/String;")) {
                            writerCpp.write("\t"
                                    + "jstring jstrRetValue = (jstring) ");
                        } else {
                            writerCpp.write("\t"
                                    + convertJniArgToCppArg(methodStructure
                                            .getReturn())
                                    + " retValue = ("
                                    + convertJniArgToCppArg(methodStructure
                                            .getReturn()) + ") ");
                        }
                    }

                    String methodType = "Object";
                    final String returnType = convertJniArgToCppArg(methodStructure
                            .getReturn());
                    if (returnType.equals("char*")) {
                        methodType = "Object";
                    } else if (returnType.equals("jarray")) {
                        methodType = "Object";
                    } else {
                        methodType = BlancoNameAdjuster
                                .toUpperCaseTitle(returnType.substring(1));
                    }
                    writerCpp.write("env->Call"
                            + (methodStructure.getStatic() ? "Static" : "")
                            + methodType
                            + "Method("
                            + (methodStructure.getStatic() ? "myClass"
                                    : "myObject") + ", mid"
                            + parameterForJniNewObject + ");");

                    writerCpp.newLine();

                    writeCheckException(writerCpp);

                    if (methodStructure.getReturn()
                            .equals("Ljava/lang/String;")) {
                        writerCpp
                                .write("\t"
                                        + "char* retValue = java2Cpp(env, jstrRetValue);");
                    }

                }

                if (methodStructure.getReturn().equals("V")) {
                    // ܂B
                } else {
                    writerCpp.write("\treturn retValue;");
                    writerCpp.newLine();
                }
                writerCpp.write("}");
                writerCpp.newLine();
                writerCpp.newLine();

            }

            writerH.write("};");
            writerH.newLine();

        } finally {
            writerCpp.close();
            writerH.close();
        }

        System.out.println(classStructure);
    }

    private void writeCheckException(final BufferedWriter writerCpp)
            throws IOException {
        if (true) {
            writerCpp.write("\t// TODO قƂ͂ŗOnhOs܂B");
            writerCpp.newLine();
            writerCpp.newLine();
            return;
        }

        writerCpp.write("\tif((jEx = env->ExceptionOccurred()) != NULL)");
        writerCpp.newLine();
        writerCpp.write("\t{");
        writerCpp.newLine();
        writerCpp.write("\t\tthrow new BlancoJniException(env, jEx);");
        writerCpp.newLine();
        writerCpp.write("\t}");
        writerCpp.newLine();
    }

    private String convertJniArgToCppArg(final String argJniArg) {
        if (argJniArg.equals("Ljava/lang/String;")) {
            return "char*";
        } else if (argJniArg.equals("Z")) {
            return "jboolean";
        } else if (argJniArg.equals("B")) {
            return "jbyte";
        } else if (argJniArg.equals("C")) {
            return "jchar";
        } else if (argJniArg.equals("S")) {
            return "jshort";
        } else if (argJniArg.equals("I")) {
            return "jint";
        } else if (argJniArg.equals("J")) {
            return "jlong";
        } else if (argJniArg.equals("F")) {
            return "jfloat";
        } else if (argJniArg.equals("D")) {
            return "jdouble";
        } else if (argJniArg.equals("V")) {
            // ł̂ƂĈ܂B
            return "jvoid";
        } else if (argJniArg.startsWith("L")) {
            return "jobject";
        } else if (argJniArg.startsWith("[")) {
            // TODO قƂ͂QڂŌ^킩܂
            return "jarray";
        } else {
            return "/*^s*/" + argJniArg;
        }
    }

    private String getSafeMethodName(String methodName) {
        if (methodName.equals("delete")) {
            return "methodDelete";
        }
        return methodName;
    }
}
