/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.bcel.util;

import java.io.File;

import blanco.bcel.valueobject.BlancoBcelClassStructure;
import blanco.bcel.valueobject.BlancoBcelFieldStructure;
import blanco.bcel.valueobject.BlancoBcelLineStructure;
import blanco.bcel.valueobject.BlancoBcelMethodStructure;
import blanco.xml.bind.BlancoXmlMarshaller;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoBcelXmlMarshaller {
    public void marshal(final BlancoBcelClassStructure classStructure,
            final File outputFile) {

        final BlancoXmlDocument document = new BlancoXmlDocument();

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = new BlancoXmlElement();
        document.getChildNodes().add(elementRoot);
        elementRoot.setLocalName("blancoBcel");

        expandClass(classStructure, elementRoot);

        expandFields(classStructure, elementRoot);

        expandMethods(classStructure, elementRoot);

        final BlancoXmlMarshaller marshaller = new BlancoXmlMarshaller();
        marshaller.marshal(document, outputFile);
    }

    private void expandClass(final BlancoBcelClassStructure classStructure,
            final BlancoXmlElement elementRoot) {
        final BlancoXmlElement elementClass = new BlancoXmlElement();
        elementRoot.getChildNodes().add(elementClass);
        elementClass.setLocalName("Class");

        {
            final BlancoXmlElement elementName = new BlancoXmlElement();
            elementClass.getChildNodes().add(elementName);
            elementName.setLocalName("Name");

            final BlancoXmlCharacters charactersName = new BlancoXmlCharacters();
            elementName.getChildNodes().add(charactersName);
            charactersName.setValue(classStructure.getName());
        }

        {
            final BlancoXmlElement elementSuperclassName = new BlancoXmlElement();
            elementClass.getChildNodes().add(elementSuperclassName);
            elementSuperclassName.setLocalName("SuperclassName");

            final BlancoXmlCharacters charactersSuperclassName = new BlancoXmlCharacters();
            elementSuperclassName.getChildNodes().add(charactersSuperclassName);
            charactersSuperclassName.setValue(classStructure
                    .getSuperclassName());
        }

        for (int index = 0; index < classStructure.getInterfaceNameList()
                .size(); index++) {
            final String interfaceName = (String) classStructure
                    .getInterfaceNameList().get(index);

            final BlancoXmlElement elementInterfaceName = new BlancoXmlElement();
            elementClass.getChildNodes().add(elementInterfaceName);
            elementInterfaceName.setLocalName("InterfaceName");

            final BlancoXmlCharacters charactersWrk = new BlancoXmlCharacters();
            elementInterfaceName.getChildNodes().add(charactersWrk);
            charactersWrk.setValue(interfaceName);
        }
    }

    private void expandFields(final BlancoBcelClassStructure classStructure,
            final BlancoXmlElement elementRoot) {
        // tB[h
        final BlancoXmlElement elementFields = new BlancoXmlElement();
        elementRoot.getChildNodes().add(elementFields);
        elementFields.setLocalName("Fields");

        for (int index = 0; index < classStructure.getFieldList().size(); index++) {
            final BlancoBcelFieldStructure fieldStructure = (BlancoBcelFieldStructure) classStructure
                    .getFieldList().get(index);

            final BlancoXmlElement elementField = new BlancoXmlElement();
            elementFields.getChildNodes().add(elementField);

            // ȑOConstantField ݂͒PField
            elementField.setLocalName("Field");

            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementField.getAtts().add(attribute);
                attribute.setLocalName("access");
                attribute.setValue(fieldStructure.getAccess());
            }
            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementField.getAtts().add(attribute);
                attribute.setLocalName("static");
                attribute.setValue(fieldStructure.getStatic() ? "true"
                        : "false");
            }
            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementField.getAtts().add(attribute);
                attribute.setLocalName("final");
                attribute
                        .setValue(fieldStructure.getFinal() ? "true" : "false");
            }

            {
                final BlancoXmlElement elementName = new BlancoXmlElement();
                elementField.getChildNodes().add(elementName);
                elementName.setLocalName("Name");

                final BlancoXmlCharacters charactersName = new BlancoXmlCharacters();
                elementName.getChildNodes().add(charactersName);
                charactersName.setValue(fieldStructure.getName());
            }

            if (fieldStructure.getStatic() && fieldStructure.getFinal()) {
                // 萔̏ꍇɂ̂ConstantValue̓WJ{܂B
                final BlancoXmlElement elementConstantValue = new BlancoXmlElement();
                elementField.getChildNodes().add(elementConstantValue);
                elementConstantValue.setLocalName("ConstantValue");

                final BlancoXmlCharacters charactersConstantValue = new BlancoXmlCharacters();
                elementConstantValue.getChildNodes().add(
                        charactersConstantValue);
                charactersConstantValue.setValue(fieldStructure
                        .getConstantValue());
            }
        }
    }

    private void expandMethods(final BlancoBcelClassStructure classStructure,
            final BlancoXmlElement elementRoot) {
        // \bh
        final BlancoXmlElement elementMethods = new BlancoXmlElement();
        elementRoot.getChildNodes().add(elementMethods);
        elementMethods.setLocalName("Methods");

        for (int index = 0; index < classStructure.getMethodList().size(); index++) {
            final BlancoBcelMethodStructure methodStructure = (BlancoBcelMethodStructure) classStructure
                    .getMethodList().get(index);

            final BlancoXmlElement elementMethod = new BlancoXmlElement();
            elementMethods.getChildNodes().add(elementMethod);

            elementMethod.setLocalName("Method");

            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementMethod.getAtts().add(attribute);
                attribute.setLocalName("access");
                attribute.setValue(methodStructure.getAccess());
            }
            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementMethod.getAtts().add(attribute);
                attribute.setLocalName("static");
                attribute.setValue(methodStructure.getStatic() ? "true"
                        : "false");
            }
            {
                final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
                elementMethod.getAtts().add(attribute);
                attribute.setLocalName("final");
                attribute.setValue(methodStructure.getFinal() ? "true"
                        : "false");
            }

            {
                final BlancoXmlElement elementName = new BlancoXmlElement();
                elementMethod.getChildNodes().add(elementName);
                elementName.setLocalName("Name");

                final BlancoXmlCharacters charactersName = new BlancoXmlCharacters();
                elementName.getChildNodes().add(charactersName);
                charactersName.setValue(methodStructure.getName());
            }

            for (int indexArg = 0; indexArg < methodStructure.getArgumentList()
                    .size(); indexArg++) {
                final String arg = (String) methodStructure.getArgumentList()
                        .get(indexArg);

                {
                    final BlancoXmlElement elementArgument = new BlancoXmlElement();
                    elementMethod.getChildNodes().add(elementArgument);
                    elementArgument.setLocalName("Argument");

                    final BlancoXmlCharacters charactersArgument = new BlancoXmlCharacters();
                    elementArgument.getChildNodes().add(charactersArgument);
                    charactersArgument.setValue(arg);
                }
            }

            {
                final BlancoXmlElement elementReturn = new BlancoXmlElement();
                elementMethod.getChildNodes().add(elementReturn);
                elementReturn.setLocalName("Return");

                final BlancoXmlCharacters charactersReturn = new BlancoXmlCharacters();
                elementReturn.getChildNodes().add(charactersReturn);
                charactersReturn.setValue(methodStructure.getReturn());
            }

            final BlancoXmlElement elementLines = new BlancoXmlElement();
            elementMethod.getChildNodes().add(elementLines);
            elementLines.setLocalName("Lines");

            for (int indexLine = 0; indexLine < methodStructure.getLinesList()
                    .size(); indexLine++) {

                final BlancoXmlElement elementLine = new BlancoXmlElement();
                elementLines.getChildNodes().add(elementLine);
                elementLine.setLocalName("Line");

                final BlancoBcelLineStructure lineStructure = (BlancoBcelLineStructure) methodStructure
                        .getLinesList().get(indexLine);

                {
                    final BlancoXmlElement elementNumber = new BlancoXmlElement();
                    elementLine.getChildNodes().add(elementNumber);
                    elementNumber.setLocalName("Number");

                    final BlancoXmlCharacters charactersWrk = new BlancoXmlCharacters();
                    elementNumber.getChildNodes().add(charactersWrk);
                    charactersWrk.setValue(String.valueOf(lineStructure
                            .getNumber()));
                }

                {
                    final BlancoXmlElement elementOperation = new BlancoXmlElement();
                    elementLine.getChildNodes().add(elementOperation);
                    elementOperation.setLocalName("Operation");

                    final BlancoXmlCharacters charactersWrk = new BlancoXmlCharacters();
                    elementOperation.getChildNodes().add(charactersWrk);
                    charactersWrk.setValue(String.valueOf(lineStructure
                            .getOperation()));
                }

                {
                    final BlancoXmlElement elementOperand = new BlancoXmlElement();
                    elementLine.getChildNodes().add(elementOperand);
                    elementOperand.setLocalName("Operand");

                    final BlancoXmlCharacters charactersWrk = new BlancoXmlCharacters();
                    elementOperand.getChildNodes().add(charactersWrk);
                    charactersWrk.setValue(String.valueOf(lineStructure
                            .getOperand()));
                }
            }
        }
    }
}
