/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.bcel.util;

import java.io.File;
import java.util.List;

import blanco.bcel.valueobject.BlancoBcelClassStructure;
import blanco.bcel.valueobject.BlancoBcelFieldStructure;
import blanco.bcel.valueobject.BlancoBcelLineStructure;
import blanco.bcel.valueobject.BlancoBcelMethodStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoBcelXmlUnmarshaller {
    public BlancoBcelClassStructure unmarshal(final File inputFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(inputFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        final BlancoBcelClassStructure classStructure = parseClass(elementRoot);
        if (classStructure == null) {
            return null;
        }

        parseFields(elementRoot, classStructure);

        parseMethods(elementRoot, classStructure);

        return classStructure;
    }

    private BlancoBcelClassStructure parseClass(
            final BlancoXmlElement elementRoot) {
        final List listClass = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "Class");
        if (listClass.size() == 0) {
            return null;
        }

        final BlancoBcelClassStructure classStructure = new BlancoBcelClassStructure();

        // ꌏڂ̂݃NXĂ_ɒӁB

        final BlancoXmlElement elementClass = (BlancoXmlElement) listClass
                .get(0);
        classStructure.setName(BlancoXmlBindingUtil.getTextContent(
                elementClass, "Name"));
        classStructure.setSuperclassName(BlancoXmlBindingUtil.getTextContent(
                elementClass, "SuperclassName"));

        final List listInterfaceName = BlancoXmlBindingUtil
                .getElementsByTagName(elementClass, "InterfaceName");
        for (int indexInterface = 0; indexInterface < listInterfaceName.size(); indexInterface++) {
            final String interfaceName = BlancoXmlBindingUtil
                    .getTextContent((BlancoXmlElement) listInterfaceName
                            .get(indexInterface));
            classStructure.getInterfaceNameList().add(interfaceName);
        }

        return classStructure;
    }

    private void parseFields(final BlancoXmlElement elementRoot,
            final BlancoBcelClassStructure classStructure) {
        final BlancoXmlElement elementFields = BlancoXmlBindingUtil.getElement(
                elementRoot, "Fields");
        if (elementFields == null) {
            return;
        }

        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                elementFields, "Field");
        final int sizeListField = listField.size();
        for (int index = 0; index < sizeListField; index++) {
            final BlancoXmlElement elementField = (BlancoXmlElement) listField
                    .get(index);
            final BlancoBcelFieldStructure fieldStructure = new BlancoBcelFieldStructure();
            classStructure.getFieldList().add(fieldStructure);

            fieldStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "Name"));

            // Agr[g擾B
            fieldStructure.setAccess(BlancoXmlBindingUtil.getAttribute(
                    elementField, "access"));
            fieldStructure.setStatic("true".equals(BlancoXmlBindingUtil
                    .getAttribute(elementField, "static")));
            fieldStructure.setFinal("true".equals(BlancoXmlBindingUtil
                    .getAttribute(elementField, "final")));

            fieldStructure.setConstantValue(BlancoXmlBindingUtil
                    .getTextContent(elementField, "ConstantValue"));
        }
    }

    private void parseMethods(final BlancoXmlElement elementRoot,
            final BlancoBcelClassStructure classStructure) {
        final BlancoXmlElement elementMethods = BlancoXmlBindingUtil
                .getElement(elementRoot, "Methods");
        if (elementMethods == null) {
            return;
        }

        final List listMethod = BlancoXmlBindingUtil.getElementsByTagName(
                elementMethods, "Method");
        final int sizeListMethod = listMethod.size();
        for (int index = 0; index < sizeListMethod; index++) {
            final BlancoXmlElement elementMethod = (BlancoXmlElement) listMethod
                    .get(index);
            final BlancoBcelMethodStructure methodStructure = new BlancoBcelMethodStructure();
            classStructure.getMethodList().add(methodStructure);

            methodStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementMethod, "Name"));

            // Agr[g擾B
            methodStructure.setAccess(BlancoXmlBindingUtil.getAttribute(
                    elementMethod, "access"));
            methodStructure.setStatic("true".equals(BlancoXmlBindingUtil
                    .getAttribute(elementMethod, "static")));
            methodStructure.setFinal("true".equals(BlancoXmlBindingUtil
                    .getAttribute(elementMethod, "final")));

            final List listArgs = BlancoXmlBindingUtil.getElementsByTagName(
                    elementMethod, "Argument");
            for (int indexArgs = 0; indexArgs < listArgs.size(); indexArgs++) {
                final BlancoXmlElement elementArgs = (BlancoXmlElement) listArgs
                        .get(indexArgs);

                methodStructure.getArgumentList().add(
                        BlancoXmlBindingUtil.getTextContent(elementArgs));
            }

            methodStructure.setReturn(BlancoXmlBindingUtil.getTextContent(
                    elementMethod, "Return"));

            final BlancoXmlElement elementLines = BlancoXmlBindingUtil
                    .getElement(elementRoot, "Lines");
            if (elementLines == null) {
                continue;
            }
            final List listLine = BlancoXmlBindingUtil.getElementsByTagName(
                    elementLines, "Line");

            for (int indexLine = 0; indexLine < listLine.size(); indexLine++) {
                final BlancoXmlElement elementLine = (BlancoXmlElement) listLine
                        .get(index);

                final BlancoBcelLineStructure lineStructure = new BlancoBcelLineStructure();
                methodStructure.getLinesList().add(lineStructure);

                // TODO p[XO̍lĂ܂B
                lineStructure.setNumber(Integer.parseInt(BlancoXmlBindingUtil
                        .getTextContent(elementLine, "Number")));
                lineStructure.setOperation(BlancoXmlBindingUtil.getTextContent(
                        elementLine, "Operation"));
                lineStructure.setOperand(BlancoXmlBindingUtil.getTextContent(
                        elementLine, "Operand"));
            }
        }
    }
}
