/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.transform.TransformerException;

import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

public class BlancoSoapWsdl2Asmx {
    private BlancoWsdlWebService fWsdl = null;

    /**
     * 
     * @param metaFile
     *            ΏۂWSDL(^t@C)B
     * @param targetDirectory
     *            o͐fBNgB
     * @throws TransformerException
     *             XMLϊOꍇB
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File metaFile, final File targetDirectory)
            throws TransformerException, IOException {
        fWsdl = new BlancoWsdlParser().parse(metaFile);

        final ArrayList listOperation = fWsdl.getOperationList();
        for (int indexOperation = 0; indexOperation < listOperation.size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) listOperation
                    .get(indexOperation);
            expandOperation(operation, targetDirectory);
        }
    }

    /**
     * operation*.asmxt@C܂B
     * 
     * @param operation
     * @param targetDirectory
     * @throws IOException
     */
    private void expandOperation(final BlancoWsdlWebServiceOperation operation,
            final File targetDirectory) throws IOException {
        final BufferedWriter writer = new BufferedWriter(new FileWriter(
                targetDirectory.getAbsolutePath() + "/"
                        + fWsdl.getWebServiceId() + ".asmx"));
        try {
            writer.write("<%@ WebService Language=\"C#\" Class=\""
                    + fWsdl.getPackage() + "." + fWsdl.getWebServiceId()
                    + "Proxy\" %>");
        } finally {
            writer.close();
        }
    }
}
