/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

/**
 * XSĎ^}bsO邽߂̃[eBeBNXłB
 * 
 * _ł͑Ή^̂݌^}bsOAȊǑ^nullƂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdTypeMapping {
    /**
     * xsdJavaƂ̌^}bsO񋟂܂B
     * 
     * IɌ^}bv`܂B`݂ƂĂ blancoXsdΉłȂ^邱Ƃɒ
     * 
     * @param type
     *            ^w肵܂B
     * @param minOccurs
     *            minOccursw肵܂BɂAK{ǂ̔fs܂B
     * @return
     */
    public static final String xsdType2JavaType(final String type,
            final String minOccurs) {
        boolean isPrimitive = true;
        if (minOccurs != null && minOccurs.equals("0")) {
            isPrimitive = false;
        }

        if (type.equals("xsd:anyURI")) {
            // TODO _ł͖ΉBURIԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:base64Binary")) {
            return "byte[]";
        }
        if (type.equals("xsd:boolean")) {
            if (isPrimitive) {
                return "boolean";
            } else {
                return "java.lang.Boolean";
            }
        }
        if (type.equals("xsd:byte")) {
            // TODO _ł͖ΉBbyteԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:date")) {
            return "java.util.Date";
        }
        if (type.equals("xsd:dateTime")) {
            return "java.util.Date";
        }
        if (type.equals("xsd:decimal")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:double")) {
            if (isPrimitive) {
                return "double";
            } else {
                return "java.lang.Double";
            }
        }
        if (type.equals("xsd:duration")) {
            // TODO _ł͖ΉBԂ̒\^Ԃ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:ENTITIES")) {
            // TODO _ł͖ΉBString[]Ԃ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:ENTITY")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:float")) {
            if (isPrimitive) {
                return "float";
            } else {
                return "java.lang.Float";
            }
        }
        if (type.equals("xsd:gDay")) {
            // TODO _ł͖ΉBDateԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:gMonth")) {
            // TODO _ł͖ΉBDateԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:gMonthDay")) {
            // TODO _ł͖ΉBDateԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:gYear")) {
            // TODO _ł͖ΉBDateԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:gYearMonth")) {
            // TODO _ł͖ΉBDateԂ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:hexBinary")) {
            // TODO _ł͖ΉBbyte[]Ԃ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:ID")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:IDREF")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:IDREFS")) {
            // TODO _ł͖ΉBString[]Ԃ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:int")) {
            if (isPrimitive) {
                return "int";
            } else {
                return "java.lang.Integer";
            }
        }
        if (type.equals("xsd:integer")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:language")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:long")) {
            if (isPrimitive) {
                return "long";
            } else {
                return "java.lang.Long";
            }
        }
        if (type.equals("xsd:Name")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:NCName")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:negativeInteger")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:NMTOKEN")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:NMTOKENS")) {
            // TODO _ł͖ΉBString[]Ԃ̂ŏIdlƍlB
            return null;
        }
        if (type.equals("xsd:nonNegativeInteger")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:nonPositiveInteger")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:normalizedString")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:NOTATION")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:positiveInteger")) {
            return "java.math.BigDecimal";
        }
        if (type.equals("xsd:QName")) {
            // TODO _ł͖ΉB
            return null;
        }
        if (type.equals("xsd:short")) {
            if (isPrimitive) {
                return "short";
            } else {
                return "java.lang.Short";
            }
        }
        if (type.equals("xsd:string")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:time")) {
            // TODO _ł͖ΉB
            return null;
        }
        if (type.equals("xsd:token")) {
            return "java.lang.String";
        }
        if (type.equals("xsd:unsignedByte")) {
            // TODO _ł͖ΉB
            return null;
        }
        if (type.equals("xsd:unsignedInt")) {
            // TODO _ł͖ΉB
            return null;
        }
        if (type.equals("xsd:unsignedLong")) {
            // TODO _ł͖ΉB
            return null;
        }
        if (type.equals("xsd:unsignedShort")) {
            // TODO _ł͖ΉB
            return null;
        }
        return null;
    }
}
