/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.BlancoSOAPPluginConstants;
import blanco.plugin.soap.actions.BlancoSOAPGenerateAction;
import blanco.plugin.soap.actions.BlancoXsd2CsSourceGenerateAction;
import blanco.plugin.soap.actions.BlancoXsd2JavaSourceGenerateAction;

/**
 * EclipsevOCɂGfB^
 * 
 * @author IGA Tosiki
 */
public class BlancoSOAPEditor extends AbstractBlancoSOAPEditor {

    private Composite top = null;

    public static final String BLANCO_META_FILE_TELEGRAM = "d`Ed`";

    // rWÄ
    private Label labelBlancoSOAPTitle = null;

    private Label labelBlancoSOAPSettingId = null;

    private Text textBlancoSOAPSettingId = null;

    private Combo comboMetaWsdlDir = null;

    private Button buttonCreateMetaWsdlFile = null;

    private Button buttonExecuteWsdl = null;

    private Button checkBoxGenerateXsdElementDeclaration = null;

    private Combo comboBlancoWsdlDir = null;

    private Button buttonExecuteXsd2JavaSource = null;

    private Button checkBoxGenerateDotNetWsdlExe = null;

    private Combo comboDotNetSdkDir = null;

    private Button buttonExecuteXsd2CsSource = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSOAPTitle = new Label(top, SWT.NONE);
        labelBlancoSOAPTitle.setText("blancoSOAP ݒt@C GfB^ ("
                + BlancoSOAPPluginConstants.VERSION + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSOAPSettingId = new Label(top, SWT.NONE);
        labelBlancoSOAPSettingId.setText("ݒID");
        textBlancoSOAPSettingId = new Text(top, SWT.BORDER);
        textBlancoSOAPSettingId.setText("blancoSOAP");
        textBlancoSOAPSettingId.setEditable(false);

        /**
         * ͓d`Ed`ZNVB
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("d`Ed`ZNV");

        Label labelMetaWsdlDir = new Label(top, SWT.NONE);
        labelMetaWsdlDir.setText("^fBNg");
        comboMetaWsdlDir = new Combo(top, SWT.NONE);
        comboMetaWsdlDir.add("meta/soap/wsdl");
        comboMetaWsdlDir.select(0);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetaWsdlFile = new Button(top, SWT.NONE);
        buttonCreateMetaWsdlFile.setText(BLANCO_META_FILE_TELEGRAM + " VK쐬");
        buttonCreateMetaWsdlFile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetaWsdlDir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/soap/wsdl' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaWsdlDir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetaWsdlDir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }

                            if (BlancoSOAPPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                BlancoSOAPPluginUtil.createFolder(input
                                        .getFile(), getProgressMonitor(),
                                        comboMetaWsdlDir.getText());
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(),
                                    BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                    "^fBNg쐬Ɏs܂Bf܂B:"
                                            + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = BlancoSOAPPlugin.getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), BLANCO_META_FILE_TELEGRAM
                                    + " VK쐬", BLANCO_META_FILE_TELEGRAM
                                    + "(^t@C)^fBNg["
                                    + comboMetaWsdlDir.getText() + "]ɍ쐬܂B"
                                    + BLANCO_META_FILE_TELEGRAM
                                    + "̐VKt@C͂ĂB",
                                    "blancoWsdlMeta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetaWsdlDir
                                                                    .getText())

                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(
                                    localURL.getPath()
                                            + BlancoSOAPPluginConstants.TEMPLATE_FILENAME_WITHOUT_EXT
                                            + ".xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetaWsdlDir.getText())
                                    .getFile(newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            BLANCO_META_FILE_TELEGRAM + " VK쐬",
                                            BLANCO_META_FILE_TELEGRAM
                                                    + "(^t@C ["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetaWsdlDir
                                                            .getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāAd`Ed` ֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteWsdl = new Button(top, SWT.NONE);
        buttonExecuteWsdl.setText("d`Ed`WSDLXSD𐶐");
        buttonExecuteWsdl
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteWsdl.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetaWsdlDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetaWsdlDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            // d`Ed`WSDL/XSD𐶐܂B
                            BlancoSOAPGenerateAction.processBlancoSOAP(input
                                    .getFile(), top.getShell(),
                                    getProgressMonitor(), comboMetaWsdlDir
                                            .getText(), comboBlancoWsdlDir
                                            .getText(),
                                    checkBoxGenerateXsdElementDeclaration
                                            .getSelection());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // blanco.wsdltH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboBlancoWsdlDir
                                            .getText());

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // soaptH_𓯊
                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboMetaWsdlDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteWsdl.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        Group group = new Group(top, SWT.NONE);
        group.setLayout(new FillLayout());
        group.setText("XSD (XML Schema) IvV");
        checkBoxGenerateXsdElementDeclaration = new Button(group, SWT.CHECK);
        checkBoxGenerateXsdElementDeclaration.setText("vf錾𐶐");
        checkBoxGenerateXsdElementDeclaration.setSelection(false);

        /**
         * WSDL/XSDZNVB
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("WSDL/XSDZNV");

        new Label(top, SWT.NONE).setText("^fBNg");
        comboBlancoWsdlDir = new Combo(top, SWT.NONE);
        comboBlancoWsdlDir.add("blanco.wsdl");
        comboBlancoWsdlDir.select(0);

        /**
         * ̓\[XR[hZNV (Java)B
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("\[XR[hZNV (Java)");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteXsd2JavaSource = new Button(top, SWT.NONE);
        buttonExecuteXsd2JavaSource.setText("WSDL/XSDJava\[XR[h𐶐");
        buttonExecuteXsd2JavaSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd2JavaSource.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboBlancoWsdlDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "WSDL^fBNg ("
                                                + comboBlancoWsdlDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            BlancoXsd2JavaSourceGenerateAction.process(input
                                    .getFile(), top.getShell(),
                                    getProgressMonitor(), comboBlancoWsdlDir
                                            .getText());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboBlancoWsdlDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd2JavaSource.setEnabled(true);
                        }
                    }

                });

        /**
         * ̓\[XR[hZNV (C#.NET)
         */

        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("");
        new Label(top, SWT.NONE).setText("\[XR[hZNV (C#.NET)");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");
        Group group2 = new Group(top, SWT.NONE);
        group2.setLayout(new FillLayout());
        group2.setText(".NET Framework SDK sIvV");
        checkBoxGenerateDotNetWsdlExe = new Button(group2, SWT.CHECK);
        checkBoxGenerateDotNetWsdlExe.setText("wsdl.exeN");
        checkBoxGenerateDotNetWsdlExe.setSelection(false);
        checkBoxGenerateDotNetWsdlExe
                .addSelectionListener(new SelectionListener() {
                    public void widgetSelected(final SelectionEvent e) {
                        comboDotNetSdkDir
                                .setEnabled(checkBoxGenerateDotNetWsdlExe
                                        .getSelection());
                    }

                    public void widgetDefaultSelected(final SelectionEvent e) {
                        comboDotNetSdkDir
                                .setEnabled(checkBoxGenerateDotNetWsdlExe
                                        .getSelection());
                    }
                });

        new Label(top, SWT.NONE).setText("SDK fBNg");
        comboDotNetSdkDir = new Combo(top, SWT.NONE);
        comboDotNetSdkDir.add("C:\\Program Files\\Microsoft.NET\\SDK\\v1.1");
        comboDotNetSdkDir.select(0);
        comboDotNetSdkDir.setEnabled(false);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteXsd2CsSource = new Button(top, SWT.NONE);
        buttonExecuteXsd2CsSource.setText("WSDL/XSDC#.NET\[XR[h𐶐");
        buttonExecuteXsd2CsSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd2CsSource.setEnabled(false);

                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboBlancoWsdlDir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "WSDL^fBNg ("
                                                + comboBlancoWsdlDir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            BlancoXsd2CsSourceGenerateAction.process(input
                                    .getFile(), top.getShell(),
                                    getProgressMonitor(), comboBlancoWsdlDir
                                            .getText(),
                                    checkBoxGenerateDotNetWsdlExe
                                            .getSelection(), comboDotNetSdkDir
                                            .getText());

                            // blancotH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "blanco.cs");

                            // tmptH_𓯊
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), "tmp");

                            // ܂łیƂē܂B
                            BlancoSOAPPluginUtil.refreshFolder(input.getFile(),
                                    getProgressMonitor(), comboBlancoWsdlDir
                                            .getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            // ēh~邽߂ɕKvłB
                            buttonExecuteXsd2CsSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        new Label(top, SWT.NONE)
                .setText("eX̐ݒl "
                        + BlancoSOAPPluginConstants.TARGET_FILENAME
                        + "t@CɕŊi[܂B");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        new Label(top, SWT.NONE).setText("^fBNg͒ʏύXɗp܂B");

        loadFromTextEditor();

        setFocusLostHandler(comboMetaWsdlDir);
        setFocusLostHandler(checkBoxGenerateXsdElementDeclaration);
        setFocusLostHandler(comboBlancoWsdlDir);
        setFocusLostHandler(checkBoxGenerateDotNetWsdlExe);
        setFocusLostHandler(comboDotNetSdkDir);
    }

    /**
     * Ǎs܂ <br>
     */
    protected void loadFromTextEditorInternal(final DOMResult argResult) {
        final Node rootNode = argResult.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final Element elementBlancoSoap = BlancoXmlUtil.getElement(
                    rootDocument, "blanco/target/blancosoap");
            if (elementBlancoSoap == null) {
                // ߂ďf܂B
                return;
            }

            if (elementBlancoSoap.getAttribute("metawsdldir") != null) {
                comboMetaWsdlDir.setText(elementBlancoSoap
                        .getAttribute("metawsdldir"));
            }
            if (elementBlancoSoap.getAttribute("blancowsdldir") != null) {
                comboBlancoWsdlDir.setText(elementBlancoSoap
                        .getAttribute("blancowsdldir"));
            }
            if (elementBlancoSoap.getAttribute("dotnetsdkdir") != null) {
                comboDotNetSdkDir.setText(elementBlancoSoap
                        .getAttribute("dotnetsdkdir"));
            }

            if (elementBlancoSoap.getAttribute("generatexsdelementdeclaration") != null) {
                checkBoxGenerateXsdElementDeclaration
                        .setSelection(elementBlancoSoap.getAttribute(
                                "generatexsdelementdeclaration").equals("true"));
            }
            if (elementBlancoSoap.getAttribute("generatedotnetwsdlexe") != null) {
                checkBoxGenerateDotNetWsdlExe.setSelection(elementBlancoSoap
                        .getAttribute("generatedotnetwsdlexe").equals("true"));
            }
        }
    }

    /**
     * ۑs܂B
     */
    protected Document saveToTextEditorInternal() {
        final Document document = BlancoXmlUtil.newDocument();
        final Element blanco = document.createElement("blanco");
        document.appendChild(blanco);
        final Element target = document.createElement("target");
        blanco.appendChild(target);
        final Element blancosoap = document.createElement("blancosoap");
        target.appendChild(blancosoap);
        blancosoap.setAttribute("metawsdldir", comboMetaWsdlDir.getText());
        blancosoap.setAttribute("blancowsdldir", comboBlancoWsdlDir.getText());
        blancosoap.setAttribute("dotnetsdkdir", comboDotNetSdkDir.getText());
        blancosoap.setAttribute("generatexsdelementdeclaration",
                checkBoxGenerateXsdElementDeclaration.getSelection() ? "true"
                        : "false");
        blancosoap
                .setAttribute("generatedotnetwsdlexe",
                        checkBoxGenerateDotNetWsdlExe.getSelection() ? "true"
                                : "false");

        return document;
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetaWsdlDir.getText().length() == 0) {
            comboMetaWsdlDir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetaWsdlDir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }
}