/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.resourcebundle.BlancoWsdlResourceBundle;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;
import blanco.xml.bind.BlancoXmlMarshaller;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * blancoWsdl̒XMLt@C`ꂽ^t@C͂ƂāAWSDLt@C𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Wsdl {
    /**
     * \[XohIuWFNgB
     */
    private final BlancoWsdlResourceBundle fBundle = new BlancoWsdlResourceBundle();

    /**
     * WSDLL邽߂̃XgB
     */
    private final ArrayList fListWsdl = new ArrayList();

    /**
     * ^ꂽXMLt@C`ꂽ^t@Cǂݍ݂܂B
     * 
     * ̉ߒ xsdt@C̃fBNgɗ\ߊi[ĂKv܂B
     * 
     * @param fileMetaFileXml
     *            XML`ꂽ^t@C
     * @param directoryXsd
     *            XSDt@Ci[ĂfBNg
     * @throws IOException
     *             o͗Oꍇ
     * @throws TransformerException
     *             XMLϊOꍇ
     * @throws SAXException
     *             SAXOꍇ
     */
    public void parse(final File fileMetaFileXml, final File directoryXsd)
            throws IOException, TransformerException, SAXException {
        final DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileMetaFileXml);
            final TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();

            // ܂uŏ́vd`A
            // EFuT[rXIDȂǂ擾B
            for (int index = 0; index < sizeListSheet; index++) {
                BlancoWsdlWebService wsdl = new BlancoWsdlWebService();
                final BlancoWsdlWebServiceOperation wsdlOperation = new BlancoWsdlWebServiceOperation();

                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]");

                final NodeList listTelegramProcess = elementSheet
                        .getElementsByTagName("blancotelegramprocess-common");
                if (listTelegramProcess.getLength() == 0) {
                    continue;
                }

                final Element elementCommon = (Element) listTelegramProcess
                        .item(0);

                // dID擾܂B
                wsdlOperation.setName(BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessId"));
                if (wsdlOperation.getName() == null) {
                    // telegramProcessId`͖̂̂ɃXLbv܂B
                    continue;
                }

                // vdID擾܂B
                wsdlOperation.setTelegramRequestId(BlancoXmlUtil
                        .getTextContent(elementCommon, "telegramRequestId"));
                if (wsdlOperation.getTelegramRequestId() == null) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck001(wsdlOperation.getName()));
                }

                // dID擾܂B
                wsdlOperation.setTelegramResponseId(BlancoXmlUtil
                        .getTextContent(elementCommon, "telegramResponseId"));
                if (wsdlOperation.getTelegramResponseId() == null) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck002(wsdlOperation.getName()));
                }

                // WebT[rXID擾܂B
                wsdl.setWebServiceId(BlancoXmlUtil.getTextContent(
                        elementCommon, "webServiceId"));
                if (wsdl.getWebServiceId() == null) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck003(wsdlOperation.getName()));
                }

                // OԂ擾܂B
                wsdl.setNamespace(BlancoXmlUtil.getTextContent(elementCommon,
                        "telegramProcessNamespace"));
                if (wsdl.getNamespace() == null) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck004(wsdlOperation.getName()));
                }

                // pbP[W擾܂B
                wsdl.setPackage(BlancoXmlUtil.getTextContent(elementCommon,
                        "packageName"));

                // P[V擾܂B
                wsdl.setLocation(BlancoXmlUtil.getTextContent(elementCommon,
                        "location"));
                if (wsdl.getLocation() == null) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck005(wsdlOperation.getName()));
                }

                // eX̃Iy[VɂĂ̖OԂ肵܂B
                // ̌̂߂ɂ XSDǂݍޕKv܂B
                // ܂ŏɗvd̖OԂm肵܂B
                wsdlOperation
                        .setNamespace(getNamespaceFromXsd(new File(directoryXsd
                                .getAbsolutePath()
                                + "/"
                                + wsdlOperation.getTelegramRequestId()
                                + ".xsd"), wsdlOperation.getName(),
                                wsdlOperation.getTelegramRequestId()));
                // `FbN̖ړIŉd̖OԂ擾܂B
                final String xsdNamespaceResponse = getNamespaceFromXsd(
                        new File(directoryXsd.getAbsolutePath() + "/"
                                + wsdlOperation.getTelegramResponseId()
                                + ".xsd"), wsdlOperation.getName(),
                        wsdlOperation.getTelegramResponseId());
                // vd̖OԂƉd̖OԂYĂُ͈̂툵Ƃ܂B
                if (wsdlOperation.getNamespace().equals(xsdNamespaceResponse) == false) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2wsdlCheck006(wsdlOperation.getName(),
                                    wsdlOperation.getTelegramRequestId(),
                                    wsdlOperation.getNamespace(), wsdlOperation
                                            .getTelegramResponseId(),
                                    xsdNamespaceResponse));
                }

                boolean isWsdlExist = false;
                for (int indexWsdl = 0; indexWsdl < fListWsdl.size(); indexWsdl++) {
                    final BlancoWsdlWebService wsdlLook = (BlancoWsdlWebService) fListWsdl
                            .get(indexWsdl);
                    if (wsdlLook.getWebServiceId().equals(
                            wsdl.getWebServiceId())) {
                        // WSDL̓o^܂B
                        if (wsdlLook.getLocation().equals(wsdl.getLocation()) == false) {
                            throw new IllegalArgumentException(fBundle
                                    .getXml2wsdlCheck007(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            wsdl.getLocation(), wsdlLook
                                                    .getLocation()));
                        }

                        // d̖OԂYĂُ͈̂툵Ƃ܂B
                        if (wsdlLook.getNamespace().equals(wsdl.getNamespace()) == false) {
                            throw new IllegalArgumentException(fBundle
                                    .getXml2wsdlCheck008(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            wsdl.getNamespace(), wsdlLook
                                                    .getNamespace()));
                        }

                        // pbP[WYĂꍇُ͈툵Ƃ܂B

                        // ̏ɂ͒ӂׂ_܂B
                        // dlƂāAEFuT[rXIDɂāApbP[W̔rȂ
                        // pbP[WĂꍇɈُI@\܂B
                        // ̔rɍۂāApbP[Ww̏ꍇɂ́AOԂ瓱opbP[W
                        // rsdlĔrsĂ܂B(o[WɂăpbP[Ŵ݂̕ɂĔrĂ܂B)
                        String lookPackage = BlancoStringUtil
                                .null2Blank(wsdlLook.getPackage());
                        if (lookPackage.length() == 0) {
                            lookPackage = BlancoNameUtil
                                    .uri2JavaPackage(wsdlLook.getNamespace());
                        }
                        String myPackage = BlancoStringUtil.null2Blank(wsdl
                                .getPackage());
                        if (myPackage.length() == 0) {
                            myPackage = BlancoNameUtil.uri2JavaPackage(wsdl
                                    .getNamespace());
                        }
                        if (myPackage.equals(lookPackage) == false) {
                            throw new IllegalArgumentException(fBundle
                                    .getXml2wsdlCheck010(wsdlOperation
                                            .getName(), wsdl.getWebServiceId(),
                                            myPackage, wsdl.getNamespace(),
                                            lookPackage, wsdlLook
                                                    .getNamespace()));
                        }

                        // ̂ŏ㏑s܂B
                        isWsdlExist = true;
                        wsdl = wsdlLook;
                        break;
                    }
                }

                // WSDL OperationWSDL\̂ɒǉ܂B
                wsdl.getOperationList().add(wsdlOperation);
                if (isWsdlExist == false) {
                    fListWsdl.add(wsdl);
                }
            }
        }
    }

    /**
     * w肳ꂽfBNgWSDLt@C𐶐܂B
     * 
     * @param targetDirectory
     *            WSDLo͂fBNg
     * @throws SAXException
     *             SAXOꍇ
     * @throws TransformerConfigurationException
     *             XMLϊOꍇ
     * @throws IOException
     *             o͗Oꍇ
     */
    public void generate(final File targetDirectory) throws SAXException,
            TransformerConfigurationException, IOException {
        // ۂWSDLt@C𐶐܂B
        for (int indexWsdl = 0; indexWsdl < fListWsdl.size(); indexWsdl++) {
            final BlancoWsdlWebService wsdl = (BlancoWsdlWebService) fListWsdl
                    .get(indexWsdl);

            final BlancoXmlDocument document = new BlancoXmlDocument();

            final BlancoXmlElement elementWsdlDefinitions = new BlancoXmlElement();
            document.getChildNodes().add(elementWsdlDefinitions);
            elementWsdlDefinitions.setQName("wsdl:definitions");

            {
                // [gm[hɑZbgB
                addAttribute(elementWsdlDefinitions, "xmlns:tns", wsdl
                        .getNamespace());
                addAttribute(elementWsdlDefinitions, "xmlns:wsdl",
                        "http://schemas.xmlsoap.org/wsdl/");
                addAttribute(elementWsdlDefinitions, "xmlns:xsd",
                        "http://www.w3.org/2001/XMLSchema");
                addAttribute(elementWsdlDefinitions, "xmlns:http",
                        "http://schemas.xmlsoap.org/wsdl/http/");
                addAttribute(elementWsdlDefinitions, "xmlns:soap",
                        "http://schemas.xmlsoap.org/wsdl/soap/");
                addAttribute(elementWsdlDefinitions, "xmlns:mime",
                        "http://schemas.xmlsoap.org/wsdl/mime/");
                addAttribute(elementWsdlDefinitions, "xmlns:jxb",
                        "http://java.sun.com/xml/ns/jaxb");

                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {
                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);

                    addAttribute(elementWsdlDefinitions, "xmlns:impl"
                            + indexOperation, wsdlOperation.getNamespace());
                }

                addAttribute(elementWsdlDefinitions, "targetNamespace", wsdl
                        .getNamespace());
            }

            final BlancoXmlElement elementWsdlTypes = new BlancoXmlElement();
            elementWsdlDefinitions.getChildNodes().add(elementWsdlTypes);
            elementWsdlTypes.setQName("wsdl:types");

            final BlancoXmlElement elementXsdSchema = new BlancoXmlElement();
            elementWsdlTypes.getChildNodes().add(elementXsdSchema);
            elementXsdSchema.setQName("xsd:schema");
            {
                addAttribute(elementXsdSchema, "targetNamespace", wsdl
                        .getNamespace());
            }

            for (int indexOperation = 0; indexOperation < wsdl
                    .getOperationList().size(); indexOperation++) {
                final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                        .getOperationList().get(indexOperation);

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementXsdSchema.getChildNodes().add(element);
                    element.setQName("xsd:include");

                    addAttribute(element, "schemaLocation", wsdlOperation
                            .getTelegramRequestId()
                            + ".xsd");
                }

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementXsdSchema.getChildNodes().add(element);
                    element.setQName("xsd:include");

                    addAttribute(element, "schemaLocation", wsdlOperation
                            .getTelegramResponseId()
                            + ".xsd");
                }

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementXsdSchema.getChildNodes().add(element);
                    element.setQName("xsd:element");

                    addAttribute(element, "name", wsdlOperation
                            .getTelegramRequestId());
                    addAttribute(element, "type", "impl" + indexOperation + ":"
                            + wsdlOperation.getTelegramRequestId());
                }

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementXsdSchema.getChildNodes().add(element);
                    element.setQName("xsd:element");

                    addAttribute(element, "name", wsdlOperation
                            .getTelegramResponseId());
                    addAttribute(element, "type", "impl" + indexOperation + ":"
                            + wsdlOperation.getTelegramResponseId());
                }
            }

            for (int indexOperation = 0; indexOperation < wsdl
                    .getOperationList().size(); indexOperation++) {
                final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                        .getOperationList().get(indexOperation);

                {
                    final BlancoXmlElement elementWsdlMessage = new BlancoXmlElement();
                    elementWsdlDefinitions.getChildNodes().add(
                            elementWsdlMessage);
                    elementWsdlMessage.setQName("wsdl:message");

                    addAttribute(elementWsdlMessage, "name", wsdlOperation
                            .getTelegramRequestId());

                    {
                        final BlancoXmlElement element = new BlancoXmlElement();
                        elementWsdlMessage.getChildNodes().add(element);
                        element.setQName("wsdl:part");

                        addAttribute(element, "name", "input");
                        addAttribute(element, "element", "tns:"
                                + wsdlOperation.getTelegramRequestId());
                    }
                }

                {
                    final BlancoXmlElement elementWsdlMessage = new BlancoXmlElement();
                    elementWsdlDefinitions.getChildNodes().add(
                            elementWsdlMessage);
                    elementWsdlMessage.setQName("wsdl:message");

                    addAttribute(elementWsdlMessage, "name", wsdlOperation
                            .getTelegramResponseId());

                    {
                        final BlancoXmlElement element = new BlancoXmlElement();
                        elementWsdlMessage.getChildNodes().add(element);
                        element.setQName("wsdl:part");

                        addAttribute(element, "name", "output");
                        addAttribute(element, "element", "tns:"
                                + wsdlOperation.getTelegramResponseId());
                    }
                }
            }

            {
                final BlancoXmlElement elementPortType = new BlancoXmlElement();
                elementWsdlDefinitions.getChildNodes().add(elementPortType);
                elementPortType.setQName("wsdl:portType");

                addAttribute(elementPortType, "name", wsdl.getWebServiceId());

                for (int indexOperation = 0; indexOperation < wsdl
                        .getOperationList().size(); indexOperation++) {

                    final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                            .getOperationList().get(indexOperation);

                    final BlancoXmlElement elementOperation = new BlancoXmlElement();
                    elementPortType.getChildNodes().add(elementOperation);
                    elementOperation.setQName("wsdl:operation");

                    addAttribute(elementOperation, "name", wsdlOperation
                            .getName());

                    {
                        final BlancoXmlElement element = new BlancoXmlElement();
                        elementOperation.getChildNodes().add(element);
                        element.setQName("wsdl:input");

                        addAttribute(element, "message", "tns:"
                                + wsdlOperation.getTelegramRequestId());
                    }

                    {
                        final BlancoXmlElement element = new BlancoXmlElement();
                        elementOperation.getChildNodes().add(element);
                        element.setQName("wsdl:output");

                        addAttribute(element, "message", "tns:"
                                + wsdlOperation.getTelegramResponseId());
                    }
                }
            }

            final BlancoXmlElement elementWsdlBinding = new BlancoXmlElement();
            elementWsdlDefinitions.getChildNodes().add(elementWsdlBinding);
            elementWsdlBinding.setQName("wsdl:binding");
            {
                addAttribute(elementWsdlBinding, "name", wsdl.getWebServiceId()
                        + "Binding");
                addAttribute(elementWsdlBinding, "type", "tns:"
                        + wsdl.getWebServiceId());
            }

            {
                final BlancoXmlElement element = new BlancoXmlElement();
                elementWsdlBinding.getChildNodes().add(element);
                element.setQName("soap:binding");

                addAttribute(element, "style", "document");
                addAttribute(element, "transport",
                        "http://schemas.xmlsoap.org/soap/http");
            }

            for (int indexOperation = 0; indexOperation < wsdl
                    .getOperationList().size(); indexOperation++) {
                final BlancoWsdlWebServiceOperation wsdlOperation = (BlancoWsdlWebServiceOperation) wsdl
                        .getOperationList().get(indexOperation);

                final BlancoXmlElement elementWsdlOperation = new BlancoXmlElement();
                elementWsdlBinding.getChildNodes().add(elementWsdlOperation);
                elementWsdlOperation.setQName("wsdl:operation");

                addAttribute(elementWsdlOperation, "name", wsdlOperation
                        .getName());

                // 2006.07.06 (0.1.0)
                // .NET Framework SDK 2.0ΉB
                // WSDL wsdl:bindingȉ soap:operation^O
                // soapActionAgr[go͂悤ɕύXB
                // : <soap:operation
                // soapAction="http://noname.org/NoService/TAAA0001" />
                // ̂悤ɁAtargetNamespace/dID soapActionƂ܂B

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementWsdlOperation.getChildNodes().add(element);
                    element.setQName("soap:operation");

                    addAttribute(element, "soapAction", wsdl.getNamespace()
                            + "/" + wsdlOperation.getName());
                }

                final BlancoXmlElement elementWsdlInput = new BlancoXmlElement();
                elementWsdlOperation.getChildNodes().add(elementWsdlInput);
                elementWsdlInput.setQName("wsdl:input");
                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementWsdlInput.getChildNodes().add(element);
                    element.setQName("soap:body");

                    addAttribute(element, "use", "literal");
                }

                final BlancoXmlElement elementWsdlOutput = new BlancoXmlElement();
                elementWsdlOperation.getChildNodes().add(elementWsdlOutput);
                elementWsdlOutput.setQName("wsdl:output");
                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementWsdlOutput.getChildNodes().add(element);
                    element.setQName("soap:body");

                    addAttribute(element, "use", "literal");
                }
            }

            final BlancoXmlElement elementWsdlService = new BlancoXmlElement();
            elementWsdlDefinitions.getChildNodes().add(elementWsdlService);
            elementWsdlService.setQName("wsdl:service");

            addAttribute(elementWsdlService, "name", wsdl.getWebServiceId()
                    + "Service");

            if (BlancoStringUtil.null2Blank(wsdl.getPackage()).length() > 0) {
                // pbP[W̏annotationƂďo͂܂B

                final BlancoXmlElement elementXsdAnnotation = new BlancoXmlElement();
                elementWsdlService.getChildNodes().add(elementXsdAnnotation);
                elementXsdAnnotation.setQName("xsd:annotation");

                final BlancoXmlElement elementXsdAppinfo = new BlancoXmlElement();
                elementXsdAnnotation.getChildNodes().add(elementXsdAppinfo);
                elementXsdAppinfo.setQName("xsd:appinfo");

                final BlancoXmlElement elementJxbSchemaBindings = new BlancoXmlElement();
                elementXsdAppinfo.getChildNodes().add(elementJxbSchemaBindings);
                elementJxbSchemaBindings.setQName("jxb:schemaBindings");

                {
                    final BlancoXmlElement element = new BlancoXmlElement();
                    elementJxbSchemaBindings.getChildNodes().add(element);
                    element.setQName("jxb:package");

                    addAttribute(element, "name", wsdl.getPackage());
                }
            }

            final BlancoXmlElement elementWsdlPort = new BlancoXmlElement();
            elementWsdlService.getChildNodes().add(elementWsdlPort);
            elementWsdlPort.setQName("wsdl:port");

            addAttribute(elementWsdlPort, "name", wsdl.getWebServiceId());
            addAttribute(elementWsdlPort, "binding", "tns:"
                    + wsdl.getWebServiceId() + "Binding");

            {
                final BlancoXmlElement element = new BlancoXmlElement();
                elementWsdlPort.getChildNodes().add(element);
                element.setQName("soap:address");

                addAttribute(element, "location", wsdl.getLocation());
            }

            // System.out.println(elementWsdlDefinitions.toString());

            final OutputStream outStreamXml = new FileOutputStream(
                    targetDirectory.getAbsolutePath() + "/"
                            + wsdl.getWebServiceId() + ".wsdl");
            try {
                new BlancoXmlMarshaller().marshal(document, outStreamXml);
            } finally {
                outStreamXml.flush();
                outStreamXml.close();
            }
        }
    }

    private static void addAttribute(final BlancoXmlElement element,
            final String qName, final String value) {
        final BlancoXmlAttribute attr = new BlancoXmlAttribute();
        attr.setQName(qName);
        attr.setValue(value);
        element.getAtts().add(attr);
    }

    /**
     * XSD̖OԂ擾܂B<br>
     * ̃\bh́AI BlancoNameUtilĂяoĂ܂B
     * 
     * @param fileXsd
     *            xsdt@C
     * @param targetName
     *            ^[QbgƂȂ閼O
     * @return
     * @throws IOException
     * @throws TransformerException
     */
    private final String getNamespaceFromXsd(final File fileXsd,
            final String telegramProcessId, final String targetName)
            throws IOException, TransformerException, SAXException {
        if (fileXsd.exists() == false) {
            throw new IllegalArgumentException(fBundle.getXml2wsdlCheck009(
                    telegramProcessId, targetName));
        }
        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fileXsd));
        try {
            final BlancoXsdParser parser = new BlancoXsdParser();
            final ComplexTypeStructure type = parser.process(inStream,
                    targetName);
            return type.getTargetNamespace();
        } finally {
            inStream.close();
        }
    }
}