/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.wsdl.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameUtil;
import blanco.wsdl.BlancoWsdlMeta2Xml;
import blanco.wsdl.BlancoWsdlXml2Wsdl;
import blanco.wsdl.BlancoWsdlXml2Xsd;
import blanco.xsd.BlancoXsdXsdValidator;

/**
 * blancoWsdl̂߂Ant^XNB
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlTask extends AbstractBlancoWsdlTask {
    /**
     * o͐fBNgB
     */
    private static final String TARGET_DIRECTORY = "/soap/wsdl";

    /**
     * ۂAnt^XNB
     */
    protected void process() throws IllegalArgumentException {
        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg[" + getMetadir()
                        + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(getTmpdir() + TARGET_DIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoWsdlMeta2Xml().processDirectory(fileMetadir, getTmpdir()
                    + TARGET_DIRECTORY + "/tmp");

            final BlancoWsdlXml2Wsdl xml2wsdl = new BlancoWsdlXml2Wsdl();

            // XMLԃt@CXSD𐶐܂B
            processXml2Xsd(xml2wsdl);

            // ꂽXSDt@C̑Ó`FbN܂B
            validateXsd();

            // W߂ꂽ񂩂WSDLt@C𐶐܂B
            xml2wsdl.generate(new File(getTargetdir()));
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    /**
     * XMLԃt@CXSD𐶐܂B<br>
     * 킹 WSDLt@Ĉ߂̏W܂B
     * 
     * @param xml2wsdl
     * @throws IOException
     * @throws SAXException
     * @throws TransformerException
     */
    private void processXml2Xsd(final BlancoWsdlXml2Wsdl xml2wsdl)
            throws IOException, SAXException, TransformerException {
        final File fileTmpSubdir = new File(getTmpdir() + TARGET_DIRECTORY
                + "/tmp");
        final File[] fileMeta2 = fileTmpSubdir.listFiles();
        if (fileMeta2 == null) {
            throw new IllegalArgumentException("fBNg["
                    + fileTmpSubdir.getAbsolutePath() + "]̈ꗗ擾Ɏs܂B");
        }

        for (int index = 0; index < fileMeta2.length; index++) {
            if (fileMeta2[index].getName().endsWith(".xml") == false) {
                continue;
            }

            // WSDLxsdsKv܂B
            final BlancoWsdlXml2Xsd xml2xsd = new BlancoWsdlXml2Xsd();
            if (getGeneratexsdelementdeclaration().equals("true")) {
                // uXML Schema̗vf錾𐶐vtrueɐݒ肵܂B
                xml2xsd.setGenerateXsdElementDeclaration(true);
            }
            xml2xsd.process(fileMeta2[index], new File(getTargetdir()));

            // xsdŐꂽxsdt@CWSDLŗpĂ܂B
            xml2wsdl.parse(fileMeta2[index], new File(getTargetdir()));
        }
    }

    /**
     * XSDt@C̓eÓ`FbN܂B
     * 
     * @throws FileNotFoundException
     * @throws IOException
     * @throws TransformerException
     * @throws SAXException
     */
    private void validateXsd() throws FileNotFoundException, IOException,
            TransformerException, SAXException {
        final File[] fileMeta3 = new File(getTargetdir()).listFiles();
        if (fileMeta3 == null) {
            // fBNgsȂǂ̗Rɂ listFilesnullԂꍇ܂B
            return;
        }

        for (int index = 0; index < fileMeta3.length; index++) {
            if (fileMeta3[index].getName().endsWith(".xsd") == false) {
                continue;
            }

            final InputStream inStream = new BufferedInputStream(
                    new FileInputStream(fileMeta3[index]));
            try {
                new BlancoXsdXsdValidator().process(inStream, BlancoNameUtil
                        .trimFileExtension(fileMeta3[index].getName()));
            } finally {
                inStream.close();
            }
        }
    }
}
