/*
 * blanco Framework Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * ̓Xg[o̓Xg[ɃRs[XbhNXłB
 * 
 * ̃NX blancoCommonsɓ\NXłB<br>
 * o̓Xg[null^ꂽꍇɂ́A̓Xg[̓ǂݎ̂Ăs܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCopyStreamThread extends Thread {
    /**
     * Rs[Ȃۂ̓̓Xg[B
     */
    private InputStream fInputStream = null;

    /**
     * Rs[Ȃۂ̏o̓Xg[B
     * 
     * lƂnullꍇ܂B
     */
    private OutputStream fOutputStream = null;

    /**
     * ̃Xg[Rs[~悤ƂĂ邩ǂtOB
     */
    private boolean isStopping = false;

    /**
     * Xg[̃Rs[s܂B
     * 
     * @param inStream
     *            ̓Xg[B
     * @param outStream
     *            o̓Xg[Bnullw肷邱Ƃ\ŁA̍ۂɂ͓̓Xg[̓ǂݎ̂ĂȂ܂B
     */
    public BlancoCopyStreamThread(final InputStream inStream,
            final OutputStream outStream) {
        fInputStream = inStream;
        fOutputStream = outStream;

        if (fInputStream == null) {
            throw new IllegalArgumentException(
                    "Xg[Rs[c[ɁA̓Xg[Ƃnull܂BnullȊO̒lw肵ĂB");
        }
    }

    /**
     * XbhۂɎs܂B
     */
    public void run() {
        for (;;) {
            synchronized (this) {
                if (isStopping) {
                    break;
                }
            }

            final byte[] buffer = new byte[2048];
            try {
                final int readLength = fInputStream.read(buffer, 0,
                        buffer.length);
                if (readLength <= 0) {
                    // ̓Xg[~܂B
                    break;
                }
                if (fOutputStream != null) {
                    fOutputStream.write(buffer, 0, readLength);
                }
            } catch (IOException e) {
                // ̗O͑z肹AX^bNƃ[X\ɂƂǂ߂܂B
                e.printStackTrace();
                // O΂ɂ̓[v𗣒E܂B
                break;
            }
        }
    }

    /**
     * Xg[Rs[̒~vȂ܂B
     * 
     * ̃\bhĂԂƃXg[Rs[ɑ΂Ē~v܂B
     */
    public synchronized void stopCopy() {
        isStopping = true;
    }
}
