/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

public class BlancoPerfomanceCommonUtil {
    public static void addPerfomanceFieldMethod(
            final BlancoCgObjectFactory cgFactory,
            final BlancoCgSourceFile cgSourceFile, final BlancoCgClass cgClass) {
        {
            final BlancoCgField cgField = cgFactory.createField(
                    "fPerfomanceNumberFormat", "java.text.NumberFormat",
                    "ptH[}Xvɂ̂ݗp鐔ltH[}b^B");
            cgClass.getFieldList().add(cgField);
            cgField.setFinal(true);
            cgField.setDefault("NumberFormat.getInstance()");
        }

        {
            final BlancoCgMethod cgMethod = cgFactory.createMethod(
                    "getUsedMemory", "ptH[}Xvɂ̂ݗp擾\bhB");
            cgClass.getMethodList().add(cgMethod);
            cgMethod.setAccess("private");
            cgMethod.getParameterList().add(
                    cgFactory.createParameter("runtime", "java.lang.Runtime",
                            "^C̃CX^XB"));
            cgMethod.setReturn(cgFactory.createReturn("long", "ʁB"));
            cgMethod.getLineList().add(
                    "return runtime.totalMemory() - runtime.freeMemory();");
        }

        {
            final BlancoCgMethod cgMethod = cgFactory.createMethod(
                    "getMemorySizeString", "ptH[}Xvɂ̂ݗp郁TCY擾\bhB");
            cgClass.getMethodList().add(cgMethod);
            cgMethod.setAccess("private");
            cgMethod.getParameterList().add(
                    cgFactory.createParameter("memorySize", "long", "TCYB"));
            cgMethod.setReturn(cgFactory.createReturn("java.lang.String",
                    "TCY̕\B"));
            cgMethod.getLineList().add(
                    "final StringBuffer result = new StringBuffer();");
            cgMethod
                    .getLineList()
                    .add(
                            "result.append(fPerfomanceNumberFormat.format(memorySize / 1024));");
            cgMethod.getLineList().add("result.append(\"(KB)\");");
            cgMethod.getLineList().add("return result.toString();");
        }

        {
            final BlancoCgMethod cgMethod = cgFactory.createMethod(
                    "getTimeString", "ptH[}Xvɂ̂ݗp~b擾\bhB");
            cgClass.getMethodList().add(cgMethod);
            cgMethod.setAccess("private");
            cgMethod.getParameterList().add(
                    cgFactory.createParameter("time", "long", "~bB"));
            cgMethod.setReturn(cgFactory.createReturn("java.lang.String",
                    "~b̕\B"));
            cgMethod.getLineList().add(
                    "final StringBuffer result = new StringBuffer();");
            cgMethod.getLineList().add("result.append(time);");
            cgMethod.getLineList().add("result.append(\"(ms)\");");
            cgMethod.getLineList().add("return result.toString();");
        }
    }
}
