/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.db.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoDb]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoDbResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoDbResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoDbResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoDbResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoDb]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoDbResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoDb", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoDb], key[METAFILE_DISPLAYNAME]
     *
     * [SQL`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQL`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[EXPANDER.DISABLE_GET_STATEMENT]
     *
     * [true] (ja)<br>
     *
     * @return key[EXPANDER.DISABLE_GET_STATEMENT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getExpanderDisableGetStatement() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("EXPANDER.DISABLE_GET_STATEMENT");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[EXPANDER.DISABLE_GET_STATEMENT]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR001]
     *
     * [SQLO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr001() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "SQLO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR002]
     *
     * [NX܂BNXpX̐ݒȂǂmFĂB] (ja)<br>
     *
     * @return key[TASK.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr002() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX܂BNXpX̐ݒȂǂmFĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR003]
     *
     * [z肳ȂSAXO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr003() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂSAXO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR004]
     *
     * [z肳Ȃo͗O܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr004() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳Ȃo͗O܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR005]
     *
     * [z肳ȂXMLp[TO܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr005() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂXMLp[TO܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoDb], key[TASK.ERR006]
     *
     * [z肳ȂXMLgXtH[}[O܂Bf܂B] (ja)<br>
     *
     * @return key[TASK.ERR006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTaskErr006() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "z肳ȂXMLgXtH[}[O܂Bf܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TASK.ERR006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoDb]AL[[TASK.ERR006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
