/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.valueobjectphp.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.doclisting.BlancoDocListingXml2CombinedXmlValueObject;
import blanco.plugin.valueobjectphp.BlancoValueObjectPhpPlugin;
import blanco.plugin.valueobjectphp.editors.BlancoValueObjectPhpPluginUtil;
import blanco.valueobjectphp.BlancoValueObjectPhpConstants;
import blanco.valueobjectphp.BlancoValueObjectPhpMeta2Xml;
import blanco.valueobjectphp.BlancoValueObjectPhpXml2SourceFile;
import blanco.valueobjectphp.resourcebundle.BlancoValueObjectPhpResourceBundle;

/**
 * ANV̏łB
 * 
 * TODO ʉFۉNX̎ĂB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectPhpGenerateAction {
    private static final BlancoValueObjectPhpResourceBundle fBundle = new BlancoValueObjectPhpResourceBundle();

    /**
     * blancoValueObject \[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param metaDir
     *            ^fBNgB
     * @param isNameAdjust
     *            Oό`sǂB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public final void process(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final boolean isNameAdjust) throws InvocationTargetException,
            InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                processInternal(ifile, workbenchMonitor,
                                        metaDir, isNameAdjust, monitor);
                                return;
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoValueObjectPhpPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoValueObjectPhpPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoValueObjectPhpPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoValueObjectPhpPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * ۂ̃ANVeB
     * 
     * @param ifile
     * @param workbenchMonitor
     * @param metaDir
     * @param isNameAdjust
     * @param monitor
     * @throws CoreException
     * @throws IOException
     * @throws TransformerException
     */
    protected void processInternal(final IFile ifile,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final boolean isNameAdjust, final IProgressMonitor monitor)
            throws CoreException, IOException, TransformerException {
        monitor.beginTask(BlancoValueObjectPhpConstants.PRODUCT_NAME
                + " \[XR[h", 10);

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("fBNg: e|tH_̒B");

        // e|tH_U폜܂B
        BlancoValueObjectPhpPluginUtil.deleteFolder(ifile, workbenchMonitor,
                "tmp" + BlancoValueObjectPhpConstants.TARGET_SUBDIRECTORY);
        BlancoValueObjectPhpPluginUtil.createFolder(ifile, workbenchMonitor,
                "tmp" + BlancoValueObjectPhpConstants.TARGET_SUBDIRECTORY);
        final IFolder tempFolder = BlancoValueObjectPhpPluginUtil.findFolder(
                ifile, workbenchMonitor, "tmp"
                        + BlancoValueObjectPhpConstants.TARGET_SUBDIRECTORY);

        // hLgꗗ̂߂̒ԃt@CpfBNgB
        final File blancoTempDirectoryDocListing = ifile.getProject()
                .getFolder("tmp/doclisting").getLocation().toFile();
        blancoTempDirectoryDocListing.mkdirs();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask(fBundle.getMetafileDisplayname() + " (*.xls)܂");
        monitor.worked(1);

        final IFolder findFolder = BlancoValueObjectPhpPluginUtil.findFolder(
                ifile, workbenchMonitor, metaDir);
        findFolder.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        new BlancoValueObjectPhpMeta2Xml() {
            protected boolean progress(final int progressCurrent,
                    final int progressTotal, final String progressItem) {
                if (monitor.isCanceled()) {
                    // f܂B
                    return false;
                }

                monitor.subTask("^t@C: t@C[" + progressItem + "]܂ ("
                        + progressCurrent + "/" + progressTotal + ")");

                return true;
            }
        }.processDirectory(findFolder.getLocation().toFile(), tempFolder
                .getLocation().toFile().getAbsolutePath());

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("tH_XV: tmptH_");
        monitor.worked(1);

        tempFolder.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        monitor.subTask("tH_쐬: blanco.phptH_");

        IFolder folderTargetDirectory = ifile.getProject().getFolder(
                "blanco.php");
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            folderTargetDirectory.create(true, true, workbenchMonitor);
        }

        monitor.subTask("tH_쐬: blanco.php/maintH_");
        final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                .getFolder("main");
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            folderTargetDirectoryWithMain.create(true, true, workbenchMonitor);
        }

        File blancoTargetDirectory = folderTargetDirectory.getLocation()
                .toFile();

        monitor.subTask("\[XR[h쐬");
        monitor.worked(1);

        IResource[] resourcesXml2 = tempFolder.members();
        for (int index = 0; index < resourcesXml2.length; index++) {
            if (monitor.isCanceled()) {
                return;
            }
            if (resourcesXml2[index] instanceof IFile) {
                IFile fileLook = (IFile) resourcesXml2[index];
                if (fileLook.getFileExtension().equals("xml") == false) {
                    // gqxmlȊÕt@C̓XLbv܂B
                    continue;
                }

                monitor.subTask("\[XR[h쐬: t@C[" + fileLook.getName()
                        + "]܂ (" + (index + 1) + "/"
                        + resourcesXml2.length + ")");

                try {
                    final BlancoValueObjectPhpXml2SourceFile xml2SourceFile = new BlancoValueObjectPhpXml2SourceFile();
                    xml2SourceFile.process(fileLook.getLocation().toFile(),
                            isNameAdjust, blancoTargetDirectory);
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(

                    "t@C[" + fileLook.getName()
                            + "]̏ɃG[܂B𒆒f܂B\n\n" + ex.toString());
                }
            }
        }

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
        monitor.worked(1);

        // hLgꗗ̂߂̒ԃt@C쐬B
        final BlancoDocListingXml2CombinedXmlValueObject doclistingCombine = new BlancoDocListingXml2CombinedXmlValueObject();
        doclistingCombine.process(tempFolder.getLocation().toFile(),
                blancoTempDirectoryDocListing);

        monitor.subTask("tH_XV: blanco.phptH_XV");
        monitor.worked(1);

        if (monitor.isCanceled()) {
            return;
        }

        folderTargetDirectory.refreshLocal(IResource.DEPTH_INFINITE,
                workbenchMonitor);
        return;
    }
}