/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.dbphp.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.db.BlancoDbConstantsPhp;
import blanco.db.BlancoDbXml2PhpClass;
import blanco.db.common.BlancoDbMeta2Xml;
import blanco.db.common.BlancoDbTableMeta2Xml;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlDb;
import blanco.plugin.dbphp.BlancoDbPhpPlugin;
import blanco.plugin.dbphp.editors.BlancoDbPhpPluginUtil;
import blanco.plugin.dbphp.resourcebundle.BlancoDbPhpPluginResourceBundle;

public class BlancoDbPhpGenerateAction {
    /**
     * vOC̃\[XohB
     */
    private static final BlancoDbPhpPluginResourceBundle fBundlePlugin = new BlancoDbPhpPluginResourceBundle();

    /**
     * blancoDb\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void processBlancoDb(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String metaDir, final BlancoDbSetting dbSetting,
            final boolean isSimpleTableProcess, final boolean isSqlMetaProcess)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoDbConstantsPhp.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: blanco.phptH_̍쐬");
                                monitor.worked(1);

                                // blancotH_΍ŏɍ쐬܂B
                                final IFolder folderTargetDirectoryBlanco = ifile
                                        .getProject().getFolder("blanco.php");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryBlanco.create(true,
                                            true, workbenchMonitor);
                                }
                                final File blancoTargetDirectory = folderTargetDirectoryBlanco
                                        .getLocation().toFile();

                                // pluginł͑΃tH_ɏo͂܂B
                                dbSetting.setTargetDir(blancoTargetDirectory
                                        .getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSimpleTableProcess) {
                                    processSimpleTable(ifile, shell,
                                            workbenchMonitor, dbSetting,
                                            monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSqlMetaProcess) {
                                    processSqlMeta(ifile, shell,
                                            workbenchMonitor, metaDir,
                                            dbSetting, monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor
                                        .subTask("tH_XV: blanco.phptH_tbV");
                                monitor.worked(1);

                                folderTargetDirectoryBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor
                                        .subTask("tH_XV: blanco.phptH_tbV");

                                // tmptH_𓯊
                                BlancoDbPhpPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, "tmp");

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: sqltH_tbV");
                                // ܂łیƂē܂B
                                BlancoDbPhpPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, metaDir);
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .getMessage());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoDbPhpPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n"
                            + ex.getTargetException().getMessage());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoDbPhpPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoDbPhpPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoDbPhpPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * P\܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param runtimePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    private static void processSimpleTable(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final BlancoDbSetting dbSetting, final IProgressMonitor monitor)
            throws InvocationTargetException, InterruptedException,
            CoreException, SQLException, SAXException, IOException,
            ParserConfigurationException, ClassNotFoundException,
            TransformerException {
        if (fBundlePlugin.getClearTmpFolder().equals("true")) {
            // tOĂꍇɂ̂݁AP\̂߂̃e|tH_U폜܂B
            monitor.subTask("P\: e|tH_𐮗܂B");
            BlancoDbPhpPluginUtil.deleteFolder(ifile, workbenchMonitor, "tmp"
                    + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/table");
        }

        BlancoDbPhpPluginUtil.createFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/table");
        final File blancoTempDirectoryTable = ifile.getProject().getFolder(
                "tmp" + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/table")
                .getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: f[^x[X̒P\^擾܂B");
        monitor.worked(1);

        final BlancoDbTableMeta2Xml tableMeta2Xml = new BlancoDbTableMeta2Xml() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): \[" + progressItem + "]𒊏o");
                return true;
            }

            protected boolean isSkipTypeForSimpleTable(
                    final BlancoDbMetaDataColumnStructure columnStructure) {
                // DotNetłł̓oCi^longvarcharʏ̕\ANZXƓɈƂł܂B
                return false;
            }
        };

        tableMeta2Xml.setFormatSql(true);
        tableMeta2Xml.process(dbSetting, blancoTempDirectoryTable);

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: ^Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // TableGatewayXMLt@CR/O}bsO
        final BlancoDbXml2PhpClass generatorTable = new BlancoDbXml2PhpClass() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): t@C[" + progressItem + "]R/O}bsO");
                return true;
            }
        };
        generatorTable.process(dbSetting, blancoTempDirectoryTable);

    }

    /**
     * SQL`t@C܂B
     * 
     * SQL`ƂR/O}bsOs܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param runtimePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws TransformerException
     * @throws ClassNotFoundException
     */
    private static void processSqlMeta(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final BlancoDbSetting dbSetting, final IProgressMonitor monitor)
            throws InvocationTargetException, InterruptedException,
            CoreException, SQLException, SAXException, IOException,
            ParserConfigurationException, TransformerException,
            ClassNotFoundException {
        monitor.worked(1);
        if (fBundlePlugin.getClearTmpFolder().equals("true")) {
            // tOĂꍇɂ̂݁ASQL`̂߂̃e|tH_U폜܂B
            monitor.subTask("SQL`: e|tH_𐮗܂B");
            BlancoDbPhpPluginUtil.deleteFolder(ifile, workbenchMonitor, "tmp"
                    + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/sql");
        }

        BlancoDbPhpPluginUtil.createFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/sql");
        final IFolder searchMetaDir = ifile.getProject().getFolder(metaDir);

        final File blancoTempDirectorySql = ifile.getProject().getFolder(
                "tmp" + BlancoDbConstantsPhp.TARGET_SUBDIRECTORY + "/sql")
                .getLocation().toFile();

        final File blancoTempDirectoryDocListing = ifile.getProject()
                .getFolder("tmp/doclisting").getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("SQL`: SQL`̏Ƃɒԃt@C(XML)𐶐܂B");
        monitor.worked(1);

        searchMetaDir.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        // Excelt@CXMLt@C܂B
        new BlancoDbMeta2Xml() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("SQL`(" + progressCurrent + "/"
                        + progressTotal + "): t@C[" + progressItem + "]𒊏o");
                return true;
            }
        }.processDirectory(searchMetaDir.getLocation().toFile(),
                blancoTempDirectorySql.getAbsolutePath());

        monitor.subTask("SQL`: Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // SQL`t@CXMLt@CR/O}bsO
        final BlancoDbXml2PhpClass generatorSql = new BlancoDbXml2PhpClass() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("SQL`(" + progressCurrent + "/"
                        + progressTotal + "): t@C[" + progressItem
                        + "]R/O}bsO");
                return true;
            }

        };
        generatorSql.process(dbSetting, blancoTempDirectorySql);

        // SQL`̈ꗗ̂߂̒ԃt@C쐬B
        final BlancoDocListingXml2CombinedXmlDb doclistingDb = new BlancoDocListingXml2CombinedXmlDb();
        doclistingDb.setBasePackage(dbSetting.getBasePackage());
        if (BlancoStringUtil.null2Blank(dbSetting.getRuntimePackage()).length() > 0) {
            doclistingDb.setRuntimePackage(dbSetting.getRuntimePackage());
        }
        doclistingDb.process(blancoTempDirectorySql,
                blancoTempDirectoryDocListing);
    }
}