/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgTransformer;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.BlancoDbXml2SqlInfo;
import blanco.db.common.IBlancoDbProgress;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.exception.DeadlockExceptionClassPhp;
import blanco.db.expander.exception.IntegrityConstraintExceptionClassPhp;
import blanco.db.expander.exception.NoRowFoundExceptionClassPhp;
import blanco.db.expander.exception.NoRowModifiedExceptionClassPhp;
import blanco.db.expander.exception.NotSingleRowExceptionClassPhp;
import blanco.db.expander.exception.TimeoutExceptionClassPhp;
import blanco.db.expander.exception.TooManyRowsFoundExceptionClassPhp;
import blanco.db.expander.exception.TooManyRowsModifiedExceptionClassPhp;
import blanco.db.expander.query.invoker.QueryInvokerClassPhp;
import blanco.db.expander.query.iterator.QueryIteratorClassPhp;
import blanco.db.util.BlancoDbMappingUtilPhp;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.valueobjectphp.BlancoValueObjectPhpXml2SourceFile;
import blanco.valueobjectphp.valueobject.BlancoValueObjectPhpFieldStructure;
import blanco.valueobjectphp.valueobject.BlancoValueObjectPhpStructure;

/**
 * XMLt@C\[XR[h𐶐܂B
 */
public abstract class BlancoDbXml2PhpClass implements IBlancoDbProgress {
    private BlancoDbSetting fDbSetting = null;

    /**
     * XMLt@C\[XR[h𐶐܂B
     * 
     * @param connDef
     *            f[^x[XڑB
     * @param blancoSqlDirectory
     *            SQL XMLt@Ci[ĂfBNgB
     * @param rootPackage
     *            [gƂȂpbP[WB
     * @param runtimePackage
     *            blancoɐݒ肷郉^CpbP[WBnullȂftHgɏóB
     * @param statementTimeout
     *            Xe[gg^CAEglB
     * @param blancoTargetSourceDirectory
     *            o͐fBNgB
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    public void process(final BlancoDbSetting argDbSetting,
            final File blancoSqlDirectory) throws SQLException, SAXException,
            IOException, ParserConfigurationException, ClassNotFoundException,
            TransformerException {
        System.out.println(BlancoDbConstantsPhp.PRODUCT_NAME + " ("
                + BlancoDbConstantsPhp.VERSION + ") \[XR[h: Jn.");

        fDbSetting = argDbSetting;

        if (BlancoStringUtil.null2Blank(fDbSetting.getRuntimePackage()).trim()
                .length() == 0) {
            fDbSetting.setRuntimePackage(null);
        }

        Connection conn = null;
        try {
            conn = BlancoDbUtil.connect(fDbSetting);
            BlancoDbUtil.getDatabaseVersionInfo(conn, fDbSetting);

            if (blancoSqlDirectory != null) {
                // w肪ꍇɂ̂ SQL`t@Ci[fBNg܂B

                // ValueObjecti[fBNg쐬܂B
                new File(blancoSqlDirectory.getAbsolutePath() + "/valueobject")
                        .mkdirs();

                final File[] fileSettingXml = blancoSqlDirectory.listFiles();
                for (int index = 0; index < fileSettingXml.length; index++) {
                    if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                        // t@C̊gq xml ł̂̂ݏ܂B
                        continue;
                    }
                    if (progress(index + 1, fileSettingXml.length,
                            fileSettingXml[index].getName()) == false) {
                        break;
                    }

                    // ̓t@Cɍs܂B
                    processEveryFile(conn, fileSettingXml[index], new File(
                            blancoSqlDirectory.getAbsolutePath()
                                    + "/valueobject"));
                }
            }

        } finally {
            BlancoDbUtil.close(conn);
            conn = null;
            System.out.println("\[XR[h: I.");
        }
    }

    /**
     * ʂXMLt@C܂B
     * 
     * @param dbInfoCollector
     * @param rootPackage
     * @param fileSqlForm
     * @param outputDirectory
     * @throws IOException
     * @throws SAXException
     * @throws TransformerException
     * @throws SQLException
     * @throws ParserConfigurationException
     */
    private void processEveryFile(final Connection conn,
            final File fileSqlForm, final File outputDirectory)
            throws IOException, SAXException, TransformerException,
            SQLException, ParserConfigurationException {

        System.out.println("t@C[" + fileSqlForm.getAbsolutePath() + "]܂");

        final BlancoDbXml2SqlInfo collector = new BlancoDbXml2SqlInfo();
        final List definition = collector
                .process(conn, fDbSetting, fileSqlForm);

        final String packageNameException = BlancoDbUtil
                .getRuntimePackage(fDbSetting)
                + ".exception";

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(fDbSetting.getTargetDir()
                + "/main");

        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();

        final BlancoCgTransformer transformer = BlancoCgTransformerFactory
                .getPhpSourceTransformer();

        // exceptionn
        transformer.transform(new DeadlockExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new IntegrityConstraintExceptionClassPhp(
                cgFactory, packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NoRowFoundExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NoRowModifiedExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NotSingleRowExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TimeoutExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TooManyRowsFoundExceptionClassPhp(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TooManyRowsModifiedExceptionClassPhp(
                cgFactory, packageNameException).expand(), fileBlancoMain);

        // utiln
        // _ł PHPłɂutilñNX͂܂B

        // iterator, invoker, caller
        for (int index = 0; index < definition.size(); index++) {
            final BlancoDbSqlInfoStructure sqlInfo = (BlancoDbSqlInfoStructure) definition
                    .get(index);
            switch (sqlInfo.getType()) {
            case BlancoDbSqlInfoTypeStringGroup.ITERATOR:
                createRowObjectClass(fDbSetting.getBasePackage(), sqlInfo,
                        outputDirectory);

                transformer.transform(new QueryIteratorClassPhp(fDbSetting,
                        sqlInfo, cgFactory).expand(), fileBlancoMain);
                break;
            case BlancoDbSqlInfoTypeStringGroup.INVOKER:
                transformer.transform(new QueryInvokerClassPhp(fDbSetting,
                        sqlInfo, cgFactory).expand(), fileBlancoMain);
                break;
            case BlancoDbSqlInfoTypeStringGroup.CALLER:
                // TODO blancoDbPhp͌ďo^̎T|[g܂B
                System.out.println("blancoDbPhp͌ďo^̎T|[g܂B");
                break;
            default:
                throw new IllegalArgumentException(
                        "zÕG[BsȃNGIuWFNg^܂B" + sqlInfo.toString());
            }
        }
    }

    /**
     * sIuWFNg쐬܂B
     * 
     * @param className
     * @param packageName
     * @param sqlInfo
     * @param outputDirectory
     * @throws SAXException
     * @throws IOException
     * @throws TransformerException
     */
    private void createRowObjectClass(final String rootPackage,
            final BlancoDbSqlInfoStructure sqlInfo, final File outputDirectory)
            throws SAXException, IOException, TransformerException {
        final String packageName = rootPackage + ".row";
        final String className = BlancoNameAdjuster.toClassName(sqlInfo
                .getName())
                + "Row";

        final BlancoValueObjectPhpStructure voStructure = new BlancoValueObjectPhpStructure();
        // O
        voStructure.setName(className);
        voStructure.setPackage(packageName);
        voStructure
                .setDescription("SQL`(" + sqlInfo.getName() + ")ɂƂÂsNXB");
        voStructure.setFileDescription("'" + className + "'s\sNXB\n");

        for (int index = 0; index < sqlInfo.getResultSetColumnList().size(); index++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) sqlInfo
                    .getResultSetColumnList().get(index);

            final BlancoValueObjectPhpFieldStructure fieldStructure = new BlancoValueObjectPhpFieldStructure();
            voStructure.getListField().add(fieldStructure);

            fieldStructure.setName(columnStructure.getName());

            // PHPłƂĂ̌^肵܂B
            fieldStructure.setType(BlancoDbMappingUtilPhp
                    .getPhpType(columnStructure));

            fieldStructure.setDescription(":[" + fieldStructure.getName()
                    + "]: DBɂ^:[" + columnStructure.getTypeName() + "]");
        }

        final BlancoValueObjectPhpXml2SourceFile xml2javaclass = new BlancoValueObjectPhpXml2SourceFile();
        if (fDbSetting.getTargetDir() == null) {
            throw new IllegalArgumentException(
                    "BlancoDbGenerator: blancoo͐tH_ݒ(null)łB");
        }
        xml2javaclass.process(voStructure, new File(fDbSetting.getTargetDir()));
    }
}
