/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.exception;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * f[^x[X̏̌ʁA1sf[^ύXȂƂONX
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @author IGA Tosiki
 */
public class NoRowModifiedExceptionClassPhp {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "NoRowModifiedException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "f[^x[X̏̌ʁA1sf[^ύXȂƂONX̃CX^X𐶐܂B";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    private String fPackage = null;

    public NoRowModifiedExceptionClassPhp(
            final BlancoCgObjectFactory cgFactory, final String argPackage) {
        fCgFactory = cgFactory;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");

        fPackage = argPackage;
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        cgClass.getExtendClassList().add(
                fCgFactory.createType(fPackage + ".NotSingleRowException"));

        {
            final List listDesc = cgClass.getLangDoc().getDescriptionList();

            listDesc.add("f[^x[X̏̌ʁA1sf[^ύXȂƂONX");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂");
            listDesc.add("̃NX́A\[XR[h̃t@CƂėp܂B");
            listDesc.add("");
            listDesc.add("@author blanco Framework");
        }

        {
            final BlancoCgField cgField = fCgFactory.createField(
                    "SQLSTATE_NOROWMODIFIED", "string", null);
            cgClass.getFieldList().add(cgField);
            cgField.setAccess("protected");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault("\"00102\"");
            cgField.getLangDoc().getDescriptionList().add(
                    "̃NX\SQLStateR[hB");
            cgField
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "̃NX𗘗pۂɂ́ASQLStateɂ͗炸ɗONX̌^ɂďԂ𔻒f悤ɂĂB");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "string", "O̐"));

            cgMethod
                    .setSuperclassInvocation("parent::__construct($reason . self::SQLSTATE_NOROWMODIFIED)");
        }

        return fCgSourceFile;
    }
}