/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.stringgroup.BlancoDbLoggingModeStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class ExecuteQueryMethod extends BlancoDbAbstractMethod {
    public ExecuteQueryMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("executeQuery",
                null);
        fCgClass.getMethodList().add(cgMethod);

        BlancoDbCgUtilJava.addExceptionToMethodDeadlockTimeoutException(
                fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add("^NGs܂B<br>");

        final List listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilJava.addBeginLogToMethod(cgMethod);
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        listLine.add("if (fStatement == null) {");
        listLine
                .add("// PreparedStatement擾̏ԂȂ̂ŁAPreparedStatement.executeQuery()sɐ旧prepareStatement()\bhĂяoĎ擾܂B");
        listLine.add("prepareStatement();");
        listLine.add("}");

        // resultSetԂł΁Acloses܂B
        listLine.add("if (fResultSet != null) {");
        listLine.add("// ǑʃZbg(ResultSet)cĂ̂ŁAUJ܂B");
        listLine.add("fResultSet.close();");
        listLine.add("fResultSet = null;");
        listLine.add("}");

        listLine.add("");

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                listLine.add("final Runtime runtime = Runtime.getRuntime();");
                listLine
                        .add("final long usedMemoryStart = BlancoDbUtil.getUsedMemory(runtime);");
                listLine
                        .add("final long startTime = System.currentTimeMillis();");
                listLine.add("fLog.info(\"\vF" + fSqlInfo.getName()
                        + "Jn\");");
                listLine.add("");
                break;
            }
        }

        listLine.add("try {");
        listLine.add("fResultSet = fStatement.executeQuery();");
        listLine.add("} catch (SQLException ex) {");
        listLine.add("throw BlancoDbUtil.convertToBlancoException(ex);");

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                listLine.add("} finally {");
                listLine
                        .add("final long endTime = System.currentTimeMillis();");
                listLine
                        .add("final long usedMemoryEnd = BlancoDbUtil.getUsedMemory(runtime);");
                listLine
                        .add("fLog.info(\"\vF"
                                + fSqlInfo.getName()
                                + "I vԁF\" + BlancoDbUtil.getTimeString(endTime - startTime) + \" IgpF\" + BlancoDbUtil.getMemorySizeString(usedMemoryEnd) + \" gpF\" + BlancoDbUtil.getMemorySizeString(usedMemoryEnd - usedMemoryStart));");
                break;
            }
        }

        listLine.add("}");
    }
}