/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgTransformer;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.BlancoDbXml2SqlInfo;
import blanco.db.common.IBlancoDbProgress;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.exception.BlancoDbExceptionClassDotNet;
import blanco.db.expander.exception.DeadlockExceptionClassDotNet;
import blanco.db.expander.exception.IntegrityConstraintExceptionClassDotNet;
import blanco.db.expander.exception.NoRowFoundExceptionClassDotNet;
import blanco.db.expander.exception.NoRowModifiedExceptionClassDotNet;
import blanco.db.expander.exception.NotSingleRowExceptionClassDotNet;
import blanco.db.expander.exception.TimeoutExceptionClassDotNet;
import blanco.db.expander.exception.TooManyRowsFoundExceptionClassDotNet;
import blanco.db.expander.exception.TooManyRowsModifiedExceptionClassDotNet;
import blanco.db.expander.query.caller.QueryCallerClassDotNet;
import blanco.db.expander.query.invoker.QueryInvokerClassDotNet;
import blanco.db.expander.query.iterator.QueryIteratorClassDotNet;
import blanco.db.util.BlancoDbMappingUtilDotNet;
import blanco.db.util.BlancoDbUtilClassDotNet;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.valueobject.BlancoValueObjectDotNetXml2CsClass;
import blanco.valueobject.concretesax.BlancoValueObjectDotNetSerializer;

/**
 * XMLt@C\[XR[h𐶐܂B
 */
public abstract class BlancoDbXml2CsClassDotNet implements IBlancoDbProgress {
    private BlancoDbSetting fDbSetting = null;

    /**
     * XMLt@C\[XR[h𐶐܂B
     * 
     * @param connDef
     *            f[^x[XڑB
     * @param blancoSqlDirectory
     *            SQL XMLt@Ci[ĂfBNgB
     * @param rootPackage
     *            [gƂȂpbP[WB
     * @param runtimePackage
     *            blancoɐݒ肷郉^CpbP[WBnullȂftHgɏóB
     * @param statementTimeout
     *            Xe[gg^CAEglB
     * @param blancoTargetSourceDirectory
     *            o͐fBNgB
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    public void process(final BlancoDbSetting argDbSetting,
            final File blancoSqlDirectory) throws SQLException, SAXException,
            IOException, ParserConfigurationException, ClassNotFoundException,
            TransformerException {
        System.out.println(BlancoDbConstantsDotNet.PRODUCT_NAME + " ("
                + BlancoDbConstantsDotNet.VERSION + ") \[XR[h: Jn.");

        fDbSetting = argDbSetting;

        if (BlancoStringUtil.null2Blank(fDbSetting.getRuntimePackage()).trim()
                .length() == 0) {
            fDbSetting.setRuntimePackage(null);
        }

        Connection conn = null;
        try {
            conn = BlancoDbUtil.connect(fDbSetting);
            BlancoDbUtil.getDatabaseVersionInfo(conn, fDbSetting);

            if (blancoSqlDirectory != null) {
                // w肪ꍇɂ̂ SQL`t@Ci[fBNg܂B

                // ValueObjecti[fBNg쐬܂B
                new File(blancoSqlDirectory.getAbsolutePath() + "/valueobject")
                        .mkdirs();

                final File[] fileSettingXml = blancoSqlDirectory.listFiles();
                for (int index = 0; index < fileSettingXml.length; index++) {
                    if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                        // t@C̊gq xml ł̂̂ݏ܂B
                        continue;
                    }
                    if (progress(index + 1, fileSettingXml.length,
                            fileSettingXml[index].getName()) == false) {
                        break;
                    }

                    // ̓t@Cɍs܂B
                    processEveryFile(conn, fileSettingXml[index], new File(
                            blancoSqlDirectory.getAbsolutePath()
                                    + "/valueobject"));
                }
            }

        } finally {
            BlancoDbUtil.close(conn);
            conn = null;
            System.out.println("\[XR[h: I.");
        }
    }

    /**
     * ʂXMLt@C܂B
     * 
     * @param dbInfoCollector
     * @param rootPackage
     * @param fileSqlForm
     * @param outputDirectory
     * @throws IOException
     * @throws SAXException
     * @throws TransformerException
     * @throws SQLException
     * @throws ParserConfigurationException
     */
    private void processEveryFile(final Connection conn,
            final File fileSqlForm, final File outputDirectory)
            throws IOException, SAXException, TransformerException,
            SQLException, ParserConfigurationException {

        System.out.println("t@C[" + fileSqlForm.getAbsolutePath() + "]܂");

        final BlancoDbXml2SqlInfo collector = new BlancoDbXml2SqlInfo();
        final List definition = collector
                .process(conn, fDbSetting, fileSqlForm);

        final String packageNameException = BlancoDbUtil
                .getRuntimePackage(fDbSetting)
                + ".exception";

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(fDbSetting.getTargetDir()
                + "/main");

        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();

        final BlancoCgTransformer transformer = BlancoCgTransformerFactory
                .getCsSourceTransformer();

        // exceptionn
        transformer.transform(new BlancoDbExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new DeadlockExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new IntegrityConstraintExceptionClassDotNet(
                cgFactory, packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NoRowFoundExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NoRowModifiedExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new NotSingleRowExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TimeoutExceptionClassDotNet(cgFactory,
                packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TooManyRowsFoundExceptionClassDotNet(
                cgFactory, packageNameException).expand(), fileBlancoMain);
        transformer.transform(new TooManyRowsModifiedExceptionClassDotNet(
                cgFactory, packageNameException).expand(), fileBlancoMain);

        // utiln
        transformer.transform(new BlancoDbUtilClassDotNet(cgFactory,
                BlancoDbUtil.getRuntimePackage(fDbSetting) + ".util",
                fDbSetting).expand(), fileBlancoMain);

        // iterator, invoker, caller
        for (int index = 0; index < definition.size(); index++) {
            final BlancoDbSqlInfoStructure sqlInfo = (BlancoDbSqlInfoStructure) definition
                    .get(index);
            switch (sqlInfo.getType()) {
            case BlancoDbSqlInfoTypeStringGroup.ITERATOR:
                createRowObjectClass(fDbSetting.getBasePackage(), sqlInfo,
                        outputDirectory);

                transformer.transform(new QueryIteratorClassDotNet(fDbSetting,
                        sqlInfo, cgFactory).expand(), fileBlancoMain);
                break;
            case BlancoDbSqlInfoTypeStringGroup.INVOKER:
                transformer.transform(new QueryInvokerClassDotNet(fDbSetting,
                        sqlInfo, cgFactory).expand(), fileBlancoMain);
                break;
            case BlancoDbSqlInfoTypeStringGroup.CALLER:
                transformer.transform(new QueryCallerClassDotNet(fDbSetting,
                        sqlInfo, cgFactory).expand(), fileBlancoMain);
                break;
            default:
                throw new IllegalArgumentException(
                        "zÕG[BsȃNGIuWFNg^܂B" + sqlInfo.toString());
            }
        }
    }

    /**
     * sIuWFNg쐬܂B
     * 
     * @param className
     * @param packageName
     * @param sqlInfo
     * @param outputDirectory
     * @throws SAXException
     * @throws IOException
     * @throws TransformerException
     */
    private void createRowObjectClass(final String rootPackage,
            final BlancoDbSqlInfoStructure sqlInfo, final File outputDirectory)
            throws SAXException, IOException, TransformerException {
        final String packageName = rootPackage + ".row";
        final String className = BlancoNameAdjuster.toClassName(sqlInfo
                .getName())
                + "Row";

        final ArrayList listFieldTypes = new ArrayList();
        for (int index = 0; index < sqlInfo.getResultSetColumnList().size(); index++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) sqlInfo
                    .getResultSetColumnList().get(index);

            listFieldTypes
                    .add(new String[] {
                            columnStructure.getName(),
                            BlancoDbMappingUtilDotNet
                                    .getFullClassName(columnStructure) });
        }

        OutputStream outStream = null;
        final File fileWorkXml = new File(outputDirectory.getAbsolutePath()
                + "/" + className + ".blancovalueobject");
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    fileWorkXml));
            BlancoValueObjectDotNetSerializer serializer = new BlancoValueObjectDotNetSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementWorkbook();
            serializer.characters("\n");
            serializer.startElementSheet("ValueObject");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectdotnetCommon();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementName();
            // O
            serializer.characters(className);
            serializer.endElementName();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementPackage();
            serializer.characters(packageName);
            serializer.endElementPackage();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementDescription();
            serializer.characters("SQL`(blancoDb)쐬ꂽsNXB\n");
            serializer.characters("'" + className + "'s\܂B\n");
            for (int index = 0; index < listFieldTypes.size(); index++) {
                final String[] columnTypes = (String[]) listFieldTypes
                        .get(index);
                final String columnName = columnTypes[0];
                final String columnType = columnTypes[1];

                serializer.characters("(" + String.valueOf(index + 1) + ") '"
                        + columnName + "' ^:" + columnType + "\n");
            }
            serializer.endElementDescription();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementFileDescription();
            serializer.characters("'" + className + "'s\sNXB\n");

            serializer.endElementFileDescription();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementBlancovalueobjectdotnetCommon();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectdotnetList();
            serializer.characters("\n");

            for (int index = 0; index < listFieldTypes.size(); index++) {
                final String[] columnTypes = (String[]) listFieldTypes
                        .get(index);
                final String columnName = columnTypes[0];
                final String columnType = columnTypes[1];

                serializer.characters("    ");
                serializer.startElementField();
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.startElementName();
                serializer.characters(columnName);
                serializer.endElementName();
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.startElementType();
                serializer.characters(columnType);
                serializer.endElementType();
                serializer.characters("\n");

                serializer.characters("      ");
                serializer.startElementDescription();
                serializer.characters("tB[h[" + columnName + "]łB");
                serializer.endElementDescription();
                serializer.characters("\n");

                serializer.characters("    ");
                serializer.endElementField();
                serializer.characters("\n");
            }

            serializer.characters("  ");
            serializer.endElementBlancovalueobjectdotnetList();
            serializer.characters("\n");
            serializer.endElementSheet();
            serializer.characters("\n");
            serializer.endElementWorkbook();
            serializer.endDocument();
            try {
                outStream.flush();
            } catch (IOException e) {
                new SAXException(e);
            }
        } finally {
            if (outStream != null) {
                outStream.close();
            }
        }

        final BlancoValueObjectDotNetXml2CsClass xml2javaclass = new BlancoValueObjectDotNetXml2CsClass();
        if (fDbSetting.getTargetDir() == null) {
            throw new IllegalArgumentException(
                    "BlancoDbGenerator: blancoo͐tH_ݒ(null)łB");
        }
        xml2javaclass.process(fileWorkXml, new File(fDbSetting.getTargetDir()));
    }
}
