/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;

/**
 * blancoDbʓIɗp郆[eBeBNXB
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2006.03.02
 * @author IGA Tosiki
 */
public class BlancoDbUtilClassDotNet {
    /**
     * ̃NXg̃NX
     */
    public static final String CLASS_NAME = "BlancoDbUtil";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    private BlancoDbSetting fDbSetting = null;

    public BlancoDbUtilClassDotNet(final BlancoCgObjectFactory cgFactory,
            final String argPackage, final BlancoDbSetting argDbSetting) {
        fCgFactory = cgFactory;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");

        this.fDbSetting = argDbSetting;
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        {
            final List listDesc = cgClass.getLangDoc().getDescriptionList();

            listDesc.add("blancoDbʓIɗp郆[eBeBNXB");
            listDesc.add("");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂B");
            listDesc
                    .add("̃NX blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");
            listDesc.add("");
            listDesc.add("@since 2006.06.30");
            listDesc.add("@author blanco Framework");
        }

        {
            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.IntegrityConstraintException");
            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.DeadlockException");
            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.TimeoutException");

            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "ConvertToBlancoException", null);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            final List listDesc = cgMethod.getLangDoc().getDescriptionList();

            listDesc
                    .add("SQLO̓e`FbNAKvɉblanco FrameworkOIuWFNgɕϊăX[܂B");
            listDesc.add("");
            listDesc
                    .add("SQLÔȂŁAblanco Framework̗OIuWFNgɕϊׂ̂ɂIntegrityConstraintException, DeadlockException, TimeoutExceptionɕϊ̏ throw ܂B");
            listDesc.add("ϊׂ悪ꍇɂ́Â܂܌̃IuWFNgԋp܂B");

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("ex",
                            "System.Data.SqlClient.SqlException",
                            "ADO.NETԋpꂽOIuWFNgB"));
            cgMethod.setReturn(fCgFactory.createReturn(
                    "System.Data.SqlClient.SqlException",
                    "ƂSQLOIuWFNgB܂œBꍇɂ́Aϊ̕KvƂ܂B"));

            final List listLine = cgMethod.getLineList();

            listLine.add("if (ex.Number == 2627) {");
            listLine
                    .add("IntegrityConstraintException exBlanco = new IntegrityConstraintException(\"f[^x[XᔽɂύXs܂B\" + ex.ToString() + \"ANumber=\" + ex.Number, ex);");
            listLine.add("throw exBlanco;");
            listLine.add("} else if (ex.Number == 1205) {");
            listLine
                    .add("// fbhbNSQLServermۂɔOBftHgł́AfbhbNm5bB");
            listLine
                    .add("DeadlockException exBlanco = new DeadlockException(\"f[^x[XfbhbNɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number, ex);");
            listLine.add("throw exBlanco;");
            listLine.add("} else if (ex.Number == 1222) {");
            listLine
                    .add("// bN҂bN^CAEg̎ԂzĔꍇ̃^CAEgBftHg̓^CAEgȂB");
            listLine
                    .add("TimeoutException exBlanco = new TimeoutException(\"f[^x[XbN҂̃^CAEgɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number, ex);");
            listLine.add("throw exBlanco;");
            listLine.add("} else if (ex.Number == -2) {");
            listLine
                    .add("// R}h̃^CAEgBSqlCommand.CommandTimeoutɂĐݒBftHg30bB");
            listLine
                    .add("TimeoutException exBlanco = new TimeoutException(\"R}h^CAEgɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number, ex);");
            listLine.add("throw exBlanco;");
            listLine.add("}");
            listLine.add("return ex;");
        }

        return fCgSourceFile;
    }
}
