/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Tosiki Iga
 */
public class GetListMethodDotNet extends BlancoDbAbstractMethod {
    public GetListMethodDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("GetList",
                "ʂXgŎ擾܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn(
                "System.Collections.ArrayList", fSqlInfo.getName()
                        + "NXListBʂ0̏ꍇɂ͋̃XgB"));

        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List listDesc = cgMethod.getLangDoc().getDescriptionList();
        listDesc.add("Xgɂ " + fSqlInfo.getName() + "NXi[܂B");
        // listDesc.add("ʂ̌炩߂킩ĂāAȂꍇɗp邱Ƃł܂B");
        // listDesc.add("ʂ̌ꍇɂ́Ã\bh͗pA
        // next()\bh𗘗p邱Ƃ߂܂B");

        cgMethod.getParameterList().add(
                fCgFactory.createParameter("size", "int", "ǂݏossB"));

        final List listLine = cgMethod.getLineList();

        listLine.add("ArrayList result = new ArrayList(size);");
        listLine.add("for (int count = 1; count <= size; count++) {");
        listLine.add("if (Next() == false) {");
        listLine.add("break;");
        listLine.add("}");
        listLine.add("result.Add(GetRow());");
        listLine.add("}");
        listLine.add("return result;");
    }
}