/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.views.item;

import java.io.File;
import java.util.ArrayList;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.cache.OnCallRefreshFileObject;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BlancoFileManagerProtocolFileItem implements
        IStructuredContentProvider {
    private FileObject[] fileRoots = null;

    private String fProtocol = null;

    public BlancoFileManagerProtocolFileItem(final String argProtocol) {
        fProtocol = argProtocol;
    }

    public String toString() {
        return fProtocol;
    }

    public Object[] getElements(final Object inputElement) {
        // fProtocol

        // ݂ file:// ̂ݑΉB
        if (fileRoots == null) {
            // Ń[g쐬܂B
            try {
                // OI java.io.File𗘗pĂ܂B
                final File[] fileRootsAsFile = File.listRoots();

                final FileSystemManager manager = VFS.getManager();

                final ArrayList listWrk = new ArrayList();

                for (int index = 0; index < fileRootsAsFile.length; index++) {
                    final FileObject fileObjectNew = new OnCallRefreshFileObject(
                            manager.resolveFile("file://"
                                    + fileRootsAsFile[index].getAbsolutePath()));

                    if (fileObjectNew.getName().getURI().equals("file:///A:/")) {
                        // uhCuɃfBXN܂BfBXNhCu ɑ}ĂBv邽߂̃R[hB
                        // TODO ̓e̓[UJX^}CYł悤ɂKv܂B
                        continue;
                    }

                    listWrk.add(fileObjectNew);
                }

                fileRoots = (FileObject[]) listWrk
                        .toArray(new FileObject[listWrk.size()]);

                return fileRoots;
            } catch (FileSystemException e) {
                e.printStackTrace();
            }
        }

        return fileRoots;
    }

    public void dispose() {
    }

    public void inputChanged(final Viewer viewer, final Object oldInput,
            final Object newInput) {
    }
}
