/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.util;

import blanco.cg.BlancoCgSupportedLang;
import blanco.commons.util.BlancoStringUtil;

/**
 * blancoCg̍sɊւ郆[eBeBłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoCgLineUtil {
    /**
     * sRg̃vtBbNX擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return sRg̃vtBbNXB󔒂܂݂܂B
     */
    public static final String getSingleLineCommentPrefix(
            final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "// ";
        case BlancoCgSupportedLang.VB:
            return "' ";
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "# ";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * 񃊃e镶擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return _uNI[g܂̓VONI[gB
     */
    public static final String getStringLiteralEnclosure(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
            return "\"";
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "'";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * Aۂ̃Iy[^擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return _uNI[g܂̓VONI[gB
     */
    public static final String getStringConcatenationOperator(
            final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
            return "+";
        case BlancoCgSupportedLang.PHP:
            return ".";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * ϐ̃vtBbNX߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return PHP̏ꍇ$߂܂B
     */
    public static final String getVariablePrefix(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.PHP:
            return "$";
        default:
            return "";
        }
    }

    /**
     * ϐ錾擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argVariableName
     *            ϐB
     * @param argTypeShortName
     *            Z^B
     * @param argInitialValue
     *            lBlꍇɂnull܂͒0̕ZbgB
     * @return ϐ錾Ps߂܂Bs̏I[łZ~R͊܂܂܂B
     */
    public static final String getVariableDeclaration(final int argTargetLang,
            final String argVariableName, final String argTypeShortName,
            final String argInitialValue) {
        String result = "";
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            result = argTypeShortName + " " + argVariableName;
            break;
        case BlancoCgSupportedLang.CS:
            result = argTypeShortName + " " + argVariableName;
            break;
        case BlancoCgSupportedLang.JS:
            // ^͗p܂B
            result = "var " + argVariableName;
            break;
        case BlancoCgSupportedLang.VB:
            result = "Dim " + argVariableName + " As " + argTypeShortName;
            break;
        case BlancoCgSupportedLang.PHP:
            // ^͗p܂B
            result = BlancoCgLineUtil.getVariablePrefix(argTargetLang)
                    + argVariableName;
            break;
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            // ^͗p܂B
            result = argVariableName;
            break;
        }

        if (BlancoStringUtil.null2Blank(argInitialValue).length() > 0) {
            result += " = " + argInitialValue;
        }
        return result;
    }

    // ȍ~̓t@T[h\bhB

    /**
     * if̊Jn̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr
     *            \B
     * @return
     */
    public static final String getIfBegin(final int argTargetLang,
            final String argExpr) {
        return BlancoCgStatementUtil.getIfBegin(argTargetLang, argExpr);
    }

    /**
     * if̏I̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return
     */
    public static final String getIfEnd(final int argTargetLang) {
        return BlancoCgStatementUtil.getIfEnd(argTargetLang);
    }

    /**
     * for̊Jn̕擾܂BJava̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr1
     *            B
     * @param argExpr2
     *            pB
     * @param argExpr3
     *            [v̂ǎ{鏈B
     * @return
     */
    public static final String getForBeginJava(final int argTargetLang,
            final String argExpr1, final String argExpr2, final String argExpr3) {
        return BlancoCgStatementUtil.getForBeginJava(argTargetLang, argExpr1,
                argExpr2, argExpr3);
    }

    /**
     * for̊Jn̕擾܂BVB.NET̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @return
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo) {
        return BlancoCgStatementUtil.getForBeginVb(argTargetLang, argCounter,
                argTo, null);
    }

    /**
     * for̊Jn̕擾܂BVB.NET̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @param argStep
     *            StepɗplBu: 2vBnull̏ꍇɂ Step͏ȗ܂B
     * @return
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo, final String argStep) {
        return BlancoCgStatementUtil.getForBeginVb(argTargetLang, argCounter,
                argTo, argStep);
    }

    /**
     * for̊Jn̕擾܂BRuby̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argFrom
     *            JnlBu: 1v
     * @param argTo
     *            IlBu: 10v
     * @return
     */
    public static final String getForBeginRuby(final int argTargetLang,
            final String argCounter, final String argFrom, final String argTo) {
        return BlancoCgStatementUtil.getForBeginRuby(argTargetLang, argCounter,
                argFrom, argTo);
    }

    /**
     * for̊Jn̕擾܂BPython̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argItem
     *            [vɎ擾B
     * @param argItems
     *            XgȂǂ̕ϐ
     * @return
     */
    public static final String getForBeginPython(final int argTargetLang,
            final String argItem, final String argItems) {
        return BlancoCgStatementUtil.getForBeginPython(argTargetLang, argItem,
                argItems);
    }

    /**
     * foȑI̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return
     */
    public static final String getForEnd(final int argTargetLang) {
        return BlancoCgStatementUtil.getForEnd(argTargetLang);
    }

    /**
     * for𔲂邽߂̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return break܂ Exit For߂܂B
     */
    public static final String getForExit(final int argTargetLang) {
        return BlancoCgStatementUtil.getForExit(argTargetLang);
    }

    /**
     * ̏I(̏ꍇZ~R)擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return Z~R܂͒0̕߂܂B
     */
    public static final String getTerminator(final int argTargetLang) {
        return BlancoCgStatementUtil.getTerminator(argTargetLang);
    }

    /**
     * while̊Jn̕擾܂BRuby̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argCon
     *            [vp邩̏fB
     * @return
     */
    public static final String getWhileBeginRuby(final int argTargetLang,
            final String argCon) {
        return BlancoCgStatementUtil.getWhileBeginRuby(argTargetLang, argCon);
    }

    /**
     * return̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr
     *            lB
     * @return Z~R͊܂݂܂B
     */
    public static final String getReturn(final int argTargetLang,
            final String argExpr) {
        return BlancoCgStatementUtil.getReturn(argTargetLang, argExpr);
    }
}