/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.message.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoMessage]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoMessageResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoMessageResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoMessageResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoMessageResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoMessage], key[METAFILE_DISPLAYNAME]
     *
     * [bZ[W`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[META2XML.ELEMENT_COMMON]
     *
     * [blancomessage-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancomessage-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[META2XML.ELEMENT_LIST]
     *
     * [blancomessage-list] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancomessage-list";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[META2XML.ELEMENT_LIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.ERR001]
     *
     * [bZ[W`ID[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W`ID[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.ERR002]
     *
     * [T|[gȂo̓vO~Oꏈn[{0}]w肳܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "T|[gȂo̓vO~Oꏈn[{0}]w肳܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.ERR003]
     *
     * [bZ[W`ID[{0}]ɂāAL[[{1}]2ȏ゠܂BL[2ȏw肷邱Ƃ͂ł܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W`ID[{0}]ɂāAL[[{1}]2ȏ゠܂BL[2ȏw肷邱Ƃ͂ł܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.FIELD_NO]
     *
     * [No.{0}: ] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.FIELD_NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "No.{0}: ";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.FIELD_NO");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.FIELD_NO]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.DESCRIPTION]
     *
     * [:L[:[{0}]A[{1}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.DESCRIPTION]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileDescription(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = ":L[:[{0}]A[{1}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.DESCRIPTION");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.DESCRIPTION]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST]
     *
     * [false] (ja)<br>
     *
     * @return key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileNoGenerateConstantIfFormatElementExist() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG]
     *
     * [[h: bZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂB] (ja)<br>
     *
     * @return key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileNoGenerateConstantIfFormatElementExistMsg() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "[h: bZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoMessage]AL[[ANTTASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
