/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoMessage]̒ېeNX
 */
package blanco.message.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Apache Ant^XN [BlancoMessage]̒ېeNXB
 *
 * bZ[W`烁bZ[WNX邽߂AntTaskłB<br>
 * ̒ېeNXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ̃NXpāApbP[W[blanco.message.task]BlancoMessageTaskNX쐬ĂBAnt^XN̏eLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancomessage&quot; classname=&quot;blanco.message.task.BlancoMessageTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public abstract class AbstractBlancoMessageTask extends Task {
    /**
     * Verbose[hœ삳邩ǂB
     */
    private String fVerbose = "false";

    /**
     * Ant^XN[metadir]Agr[gB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     * K{<br>
     */
    private String fMetadir;

    /**
     * Ant^XN[targetdir]Agr[gB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     */
    private String fTargetdir;

    /**
     * Ant^XN[tmpdir]Agr[gB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     */
    private String fTmpdir;

    /**
     * Ant^XN[targetlang]Agr[gB
     *
     * ڔԍ: 4<br>
     * ^[QbgƂȂvO~OꏈnBjava, cs, js, vbI\<br>
     */
    private String fTargetlang;

    /**
     * Ant^XN[constants]Agr[gB
     *
     * ڔԍ: 5<br>
     * NX̒萔Ƃďo͂邩ǂB<br>
     */
    private String fConstants;

    /**
     * Verbose[hœ삳邩ǂB
     *
     * @param arg Verbose[hœ삳邩ǂB
     */
    public void setVerbose(final String arg) {
        fVerbose = arg;
    }

    /**
     * Verbose[hœ삳邩ǂB
     *
     * @return Verbose[hœ삳邩ǂB
     */
    public String getVerbose() {
        return fVerbose;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fMetadir = arg;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fMetadir;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fTargetdir = arg;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fTmpdir = arg;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fTmpdir;
    }

    /**
     * Ant^XN[targetlang]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * ^[QbgƂȂvO~OꏈnBjava, cs, js, vbI\<br>
     *
     * @param arg Zbgl
     */
    public void setTargetlang(final String arg) {
        fTargetlang = arg;
    }

    /**
     * Ant^XN[targetlang]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * ^[QbgƂȂvO~OꏈnBjava, cs, js, vbI\<br>
     * ftHgl[java]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetlang() {
        return fTargetlang;
    }

    /**
     * Ant^XN[constants]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * NX̒萔Ƃďo͂邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setConstants(final String arg) {
        fConstants = arg;
    }

    /**
     * Ant^XN[constants]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * NX̒萔Ƃďo͂邩ǂB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getConstants() {
        return fConstants;
    }

    /**
     * ۂAntTask̏ɂāÃ\bhI[o[Ch܂B
     *
     * @throws IllegalArgumentException o͂ȂǂɂėOꍇB
     */
    protected abstract void process() throws IllegalArgumentException;

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoMessageTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (getMetadir() == null) {
            throw new BuildException("Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[targetdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTargetdir() == null) {
            setTargetdir("blanco");
        }
        // ڔԍ[3]AAgr[g[tmpdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTmpdir() == null) {
            setTmpdir("tmp");
        }
        // ڔԍ[4]AAgr[g[targetlang]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTargetlang() == null) {
            setTargetlang("java");
        }
        // ڔԍ[5]AAgr[g[constants]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getConstants() == null) {
            setConstants("false");
        }

        if ("true".equals(getVerbose())) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- targetlang:[" + getTargetlang() + "]");
            System.out.println("- constants:[" + getConstants() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            process();
        } catch (IllegalArgumentException e) {
            if ("true".equals(getVerbose())) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
