/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.batchprocess;

/**
 * ob`̃TvvOB̃NX͒PɃTvłBۂ̓ɂ͗p܂B
 */
public abstract class AbstractSampleBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ob`OIBIBatchProcessExceptionꍇB
     */
    public static final int END_BATCHPROCESS_EXCEPTION = 7;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * Gg|CgB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // AbstractSampleBatchProcessNXpblanco.sample.batchprocesspbP[WSampleBatchProcessNX쐬܂B
        AbstractSampleBatchProcess batchProcess = new SampleBatchProcess();

        // ob`̈B
        String argRequire = null;
        String argDispstr = "Ɏw肪ꍇ̕";
        String argNormalparam = null;

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-require=")) {
                argRequire = arg.substring(9);
            } else if (arg.startsWith("-dispstr=")) {
                argDispstr = arg.substring(9);
            } else if (arg.startsWith("-normalparam=")) {
                argNormalparam = arg.substring(13);
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("SampleBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (argRequire == null) {
            System.out.println("SampleBatchProcess: JnsBK{̓̓p[^[require]ݒ肳Ă܂B");
            usage();
            System.exit(END_ERROR);
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(argRequire, argDispstr, argNormalparam);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ob`eLq郁\bhB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param argRequire K{̃TvB
     * @param argDispstr \̃TvB
     * @param argNormalparam K{łȂA܂ftHgȂ̗B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public abstract int process(final String argRequire, final String argDispstr, final String argNormalparam);

    /**
     * ob`sۂɌĂяo܂B
     *
     * @param argRequire K{̃TvB
     * @param argDispstr \̃TvB
     * @param argNormalparam K{łȂA܂ftHgȂ̗B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public final int execute(final String argRequire, final String argDispstr, final String argNormalparam) {
        try {
            System.out.println("SampleBatchProcess: begin");

            // ob`̖{̂s܂B
            int retCode = process(argRequire, argDispstr, argNormalparam);

            System.out.println("SampleBatchProcess: end (" + retCode + ")");
            return retCode;
        } catch (BlancoBatchProcessException ex) {
            System.out.println("SampleBatchProcess: ob`O܂Bob`𒆒f܂B:" + ex.toString());
            // ob`OIB
            return END_BATCHPROCESS_EXCEPTION;
        } catch (IllegalArgumentException ex) {
            System.out.println("SampleBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("SampleBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("SampleBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * g̐B
     */
    public static final void usage() {
        System.out.println("SampleBatchProcess: Usage:");
        System.out.println("  java blanco.sample.batchprocess.SampleBatchProcess -require=l1 -dispstr=l2 -normalparam=l3");
        System.out.println("    -require");
        System.out.println("      K{p[^B");
        System.out.println("    -dispstr");
        System.out.println("      [\̃TvB]");
        System.out.println("      ftHgl[Ɏw肪ꍇ̕]");
        System.out.println("    -normalparam");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
