/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.batchprocess.valueobject;

import junit.framework.TestCase;

/**
 * NX[BlancoBatchProcessOutputStructure]̒P̎NXB
 *
 * ̃NXJUnit̃eXgP[XłB
 */
public class BlancoBatchProcessOutputStructureTest extends TestCase {
    /**
     * tB[h[endSuccess]̒P̎\bh
     *
     * ̃\bhł́ANX[BlancoBatchProcessOutputStructure]̃tB[h[endSuccess] ([java.lang.String]^)ɂĎs܂B<br>
     *
     * @throws Exception
     */
    public void testEndSuccess() throws Exception {
        // P̎̒ŗpValueObjectCX^X𐶐܂B
        final BlancoBatchProcessOutputStructure valueObject = new BlancoBatchProcessOutputStructure();

        // ValueObject̃tB[hɑ΂ăftHglݒ肳Ăꍇ̎s܂B
        assertEquals("[]ftHgl: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^X𐶐ɁAtB[h[endSuccess]̒l擾[0]邱Ƃ̊mF", "0", valueObject.getEndSuccess());

        // ̎s܂B
        valueObject.setEndSuccess("f[^");
        assertEquals("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endSuccess]̃Zb^[\bhgĕ[f[^]ݒ肷ƁAtB[h[endSuccess]̃Qb^[\bhg[f[^]擾ł邱Ƃ̊mF", "f[^", valueObject.getEndSuccess());

        // null̎s܂B
        valueObject.setEndSuccess(null);
        assertEquals("[E]nulll: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endSuccess]̃Zb^[\bhgnullZbgꍇɂ́AtB[h[endSuccess]̃Qb^[\bhgnull擾ł邱Ƃ̊mF", null, valueObject.getEndSuccess());

        // Zb^[ŗ^CX^XƃQb^[Ŏ擾CX^XƂv邱Ƃ܂B
        final String strInstanceCheck = "f[^Q";
        valueObject.setEndSuccess(strInstanceCheck);
        assertTrue("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endSuccess]̃Zb^[\bhgjava.lang.StringIuWFNg̃CX^Xݒ肷ƁAtB[h[endSuccess]̃Qb^[\bhgējava.lang.StringIuWFNg̃CX^X擾邱Ƃ̊mF", strInstanceCheck == valueObject.getEndSuccess());

    }

    /**
     * tB[h[endError]̒P̎\bh
     *
     * ̃\bhł́ANX[BlancoBatchProcessOutputStructure]̃tB[h[endError] ([java.lang.String]^)ɂĎs܂B<br>
     *
     * @throws Exception
     */
    public void testEndError() throws Exception {
        // P̎̒ŗpValueObjectCX^X𐶐܂B
        final BlancoBatchProcessOutputStructure valueObject = new BlancoBatchProcessOutputStructure();

        // ValueObject̃tB[hɑ΂ăftHglݒ肳Ăꍇ̎s܂B
        assertEquals("[]ftHgl: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^X𐶐ɁAtB[h[endError]̒l擾[-1]邱Ƃ̊mF", "-1", valueObject.getEndError());

        // ̎s܂B
        valueObject.setEndError("f[^");
        assertEquals("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endError]̃Zb^[\bhgĕ[f[^]ݒ肷ƁAtB[h[endError]̃Qb^[\bhg[f[^]擾ł邱Ƃ̊mF", "f[^", valueObject.getEndError());

        // null̎s܂B
        valueObject.setEndError(null);
        assertEquals("[E]nulll: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endError]̃Zb^[\bhgnullZbgꍇɂ́AtB[h[endError]̃Qb^[\bhgnull擾ł邱Ƃ̊mF", null, valueObject.getEndError());

        // Zb^[ŗ^CX^XƃQb^[Ŏ擾CX^XƂv邱Ƃ܂B
        final String strInstanceCheck = "f[^Q";
        valueObject.setEndError(strInstanceCheck);
        assertTrue("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[endError]̃Zb^[\bhgjava.lang.StringIuWFNg̃CX^Xݒ肷ƁAtB[h[endError]̃Qb^[\bhgējava.lang.StringIuWFNg̃CX^X擾邱Ƃ̊mF", strInstanceCheck == valueObject.getEndError());

    }

    /**
     * tB[h[description]̒P̎\bh
     *
     * ̃\bhł́ANX[BlancoBatchProcessOutputStructure]̃tB[h[description] ([java.lang.String]^)ɂĎs܂B<br>
     *
     * @throws Exception
     */
    public void testDescription() throws Exception {
        // P̎̒ŗpValueObjectCX^X𐶐܂B
        final BlancoBatchProcessOutputStructure valueObject = new BlancoBatchProcessOutputStructure();

        // ValueObject̃tB[hɑ΂ăftHglݒ肳ĂȂꍇ̎s܂B
        assertEquals("[]ftHgl: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^X𐶐ɁAtB[h[description]̒l擾null邱Ƃ̊mF", null, valueObject.getDescription());

        // ̎s܂B
        valueObject.setDescription("f[^");
        assertEquals("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[description]̃Zb^[\bhgĕ[f[^]ݒ肷ƁAtB[h[description]̃Qb^[\bhg[f[^]擾ł邱Ƃ̊mF", "f[^", valueObject.getDescription());

        // null̎s܂B
        valueObject.setDescription(null);
        assertEquals("[E]nulll: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[description]̃Zb^[\bhgnullZbgꍇɂ́AtB[h[description]̃Qb^[\bhgnull擾ł邱Ƃ̊mF", null, valueObject.getDescription());

        // Zb^[ŗ^CX^XƃQb^[Ŏ擾CX^XƂv邱Ƃ܂B
        final String strInstanceCheck = "f[^Q";
        valueObject.setDescription(strInstanceCheck);
        assertTrue("[]: NXo[IuWFNg[BlancoBatchProcessOutputStructure]̃CX^Xɑ΂āAtB[h[description]̃Zb^[\bhgjava.lang.StringIuWFNg̃CX^Xݒ肷ƁAtB[h[description]̃Qb^[\bhgējava.lang.StringIuWFNg̃CX^X擾邱Ƃ̊mF", strInstanceCheck == valueObject.getDescription());

    }

    /**
     *
     * @throws Exception
     */
    public void testToString() throws Exception {
        final BlancoBatchProcessOutputStructure valueObject = new BlancoBatchProcessOutputStructure();
        System.out.println(valueObject.toString());
    }
}
