/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.batchprocess.resourcebundle.BlancoBatchProcessResourceBundle;
import blanco.batchprocess.stringgroup.BlancoBatchProcessSupportedLangStringGroup;
import blanco.batchprocess.valueobject.BlancoBatchProcessInparameterListStructure;
import blanco.batchprocess.valueobject.BlancoBatchProcessOutputStructure;
import blanco.batchprocess.valueobject.BlancoBatchProcessStructure;
import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uob``vExcellob`钊ېeNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoBatchProcessXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoBatchProcessResourceBundle fBundle = new BlancoBatchProcessResourceBundle();

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argRuntimePackage, final String argTargetLang,
            final File argDirectoryTarget) throws IOException {

        int targetLang = new BlancoBatchProcessSupportedLangStringGroup()
                .convertToInt(argTargetLang);
        if (targetLang == BlancoBatchProcessSupportedLangStringGroup.NOT_DEFINED) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(argTargetLang));
        }

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // ̓p[^擾܂B
            final BlancoXmlElement elementInparameterList = BlancoXmlBindingUtil
                    .getElement(elementSheet,
                            "blancobatchprocess-inparameter-list");

            // o̓p[^擾܂B
            final BlancoXmlElement elementOutput = BlancoXmlBindingUtil
                    .getElement(elementSheet, "blancobatchprocess-output");

            // V[gڍׂȏ擾܂B
            final BlancoBatchProcessStructure processStructure = parseSheet(
                    elementCommon, elementInparameterList, elementOutput,
                    argDirectoryTarget);

            if (processStructure != null) {
                // ^̉͌ʂƂɃ\[XR[hs܂B
                new BlancoBatchProcessExpandBatchProcess().expandSourceFile(
                        processStructure, argRuntimePackage, targetLang,
                        argDirectoryTarget);
            }

        }

        if (BlancoStringUtil.null2Blank(argRuntimePackage).length() > 0) {
            // ^CpbP[W̎w肪̂ŁA𐶐܂B
            new BlancoBatchProcessExpandException().expandSourceFile(
                    argRuntimePackage, targetLang, argDirectoryTarget);
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param argElementList
     *            ݏĂListm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoBatchProcessStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final BlancoXmlElement argElementList,
            final BlancoXmlElement argElementOutput,
            final File argDirectoryTarget) {

        final BlancoBatchProcessStructure processStructure = new BlancoBatchProcessStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (argElementList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                argElementList, "inparameter");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);
            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;

            final BlancoBatchProcessInparameterListStructure field = new BlancoBatchProcessInparameterListStructure();

            field.setName(BlancoXmlBindingUtil.getTextContent(elementField,
                    "name"));
            if (BlancoStringUtil.null2Blank(field.getName()).length() == 0) {
                continue;
            }

            field.setIsRequire("true".equals(BlancoXmlBindingUtil
                    .getTextContent(elementField, "isRequire")));
            field.setDefault(BlancoXmlBindingUtil.getTextContent(elementField,
                    "default"));
            field.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementField, "description"));

            if (field.getIsRequire() && field.getDefault() != null) {
                throw new IllegalArgumentException(fBundle
                        .getXml2sourceFileErr003(processStructure.getName(),
                                field.getName()));
            }

            processStructure.getListField().add(field);
        }

        // o͒l擾܂B
        {
            BlancoBatchProcessOutputStructure field = new BlancoBatchProcessOutputStructure();

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(argElementOutput,
                            "end-success")).length() > 0) {
                field.setEndSuccess(BlancoXmlBindingUtil.getTextContent(
                        argElementOutput, "end-success"));
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(argElementOutput,
                            "end-batchprocess-exception")).length() > 0) {
                field.setEndBatchProcessException(BlancoXmlBindingUtil
                        .getTextContent(argElementOutput,
                                "end-batchprocess-exception"));
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(argElementOutput,
                            "end-illegal-argument")).length() > 0) {
                field.setEndIllegalArgument(BlancoXmlBindingUtil
                        .getTextContent(argElementOutput,
                                "end-illegal-argument"));
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(argElementOutput,
                            "end-error")).length() > 0) {
                field.setEndError(BlancoXmlBindingUtil.getTextContent(
                        argElementOutput, "end-error"));
            }

            field.setDescription(BlancoXmlBindingUtil.getTextContent(
                    argElementOutput, "description"));

            processStructure.setOutput(field);
        }

        return processStructure;
    }
}
